/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.handler.impl.WaitTimeForShipArrival;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ShipArrivalForLoading
extends WaitTimeForShipArrival {
    private final int requiredAmount;
    private final int premium;
    @Autowired
    @XStreamOmitField
    private EventHandlerFactory eventHandlerFactory;

    public ShipArrivalForLoading(ICity city, IPlayer player, LocalDateTime deadline, int requiredAmount, int premium) {
        super(city, player, deadline);
        this.requiredAmount = requiredAmount;
        this.premium = premium;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public boolean execute() {
        this.unregisterEventBus();
        if (ShipArrivalForLoading.hasShipEnoughCapacity(this.getShip(), this.requiredAmount)) {
            IShip s = (IShip)this.getShip();
            s.setOccupiedSpace(this.requiredAmount + s.getOccupiedSpace());
            LocalDateTime waitTenDays = this.getDate().getCurrentDate().plusDays(10L);
            this.eventHandlerFactory.getDeliverPackagesHandler(this.getCity(), s, waitTenDays, this.premium, this.requiredAmount);
            return true;
        }
        return false;
    }

    private static boolean hasShipEnoughCapacity(INavigableVessel ship, int requiredAmount) {
        return ship instanceof IShip && ship.getCapacity() > requiredAmount;
    }
}

