/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class BuyWares
extends TimedTask {
    private final IHumanPlayer player;
    private final ICity city;
    private final AmountablePrice<IWare> amountable;
    private final IWare ware;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private ModelTranslations translator;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    public BuyWares(ICityPlayerProxyJFX cityPlayerProxy, IBuyer buyer) {
        this.setExecutionTime(buyer.getTimeFrame());
        this.player = cityPlayerProxy.getPlayer();
        this.city = cityPlayerProxy.getCity();
        this.amountable = buyer.getAmountablePrice();
        this.ware = buyer.getWare();
    }

    public void run() {
        ITradingOffice tradingOffice;
        AmountablePrice amountable;
        Optional optOffice = this.player.findTradingOffice(this.city);
        int amountRequired = this.amountable.getAmount();
        int retrieved = 0;
        if (optOffice.isPresent() && (amountable = (tradingOffice = (ITradingOffice)optOffice.get()).getWare(this.ware)).getAmount() > 0) {
            retrieved = tradingOffice.move(this.ware, -amountRequired, amountable.getAVGPrice());
            this.player.getCompany().updateCash((long)(amountable.getAVGPrice() * retrieved));
        }
        if (retrieved < amountRequired) {
            List ships = this.player.findShips(this.city);
            for (INavigableVessel ship : ships) {
                AmountablePrice amountable2;
                if (!(ship instanceof IShip) || (amountable2 = ship.getWare(this.ware)).getAmount() <= 0) continue;
                int toRetrieve = amountRequired - retrieved;
                if (optOffice.isPresent()) {
                    retrieved += ((ITradingOffice)optOffice.get()).move(this.ware, -toRetrieve, amountable2.getAVGPrice());
                }
                this.player.getCompany().updateCash((long)(amountable2.getAVGPrice() * retrieved));
                if (retrieved < amountRequired) continue;
                break;
            }
        }
        if (retrieved < amountRequired) {
            DisplayMessage msg = retrieved == 0 ? new DisplayMessage("ch.sahits.game.openpatrician.display.event.task.BuyWares.message1", new Object[]{this.ware, this.city.getName()}) : new DisplayMessage("ch.sahits.game.openpatrician.display.event.task.BuyWares.message2", new Object[]{retrieved, this.ware, this.amountable.getAmount(), this.city.getName()});
            this.clientEventBus.post((Object)msg);
        }
    }
}

