/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageOfferState;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class MarriageOfferTimedTask
extends TimedTask {
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private StateFactory stateFactory;
    private IHumanPlayer player;
    private MarriageBrokerAnnouncementState state;
    private LocalDateTime deadLine;

    public MarriageOfferTimedTask(IHumanPlayer player, MarriageBrokerAnnouncementState state, LocalDateTime deadLine) {
        this.player = player;
        this.state = state;
        this.deadLine = deadLine;
        this.setExecutionTime(deadLine);
    }

    public void run() {
        ISpouseData spouse = this.createSpouse(this.state);
        MarriageOfferState marriageOffer = MarriageOfferState.builder().date(this.deadLine).fromFirstName(this.state.getFromFirstName()).fromLastName(this.state.getFromLastName()).location(this.state.getLocation()).player((IPlayer)this.player).tillDate(this.deadLine.plusDays(30L)).spouse(spouse).build();
        this.clientEventBus.post((Object)marriageOffer);
    }

    @VisibleForTesting
    ISpouseData createSpouse(MarriageBrokerAnnouncementState state) {
        return this.stateFactory.createSpouse(state, (IPlayer)this.player);
    }
}

