/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.graphic.image.ImageScaleState;
import ch.sahits.game.graphic.image.model.ImageData;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.GameFactory;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.EViewState;
import ch.sahits.game.openpatrician.display.dialog.service.DialogFactory;
import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.gameplay.impl.PolygonInitializerFactory;
import ch.sahits.game.openpatrician.display.javafx.BaseMainGameImageView;
import ch.sahits.game.openpatrician.display.javafx.DisplayMessageOverlay;
import ch.sahits.game.openpatrician.display.javafx.IDialogContoller;
import ch.sahits.game.openpatrician.display.javafx.MainGameImageView;
import ch.sahits.game.openpatrician.display.javafx.SceneEventHandlerFactory;
import ch.sahits.game.openpatrician.display.javafx.SeamapImageView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.data.DisplayEventVideo;
import ch.sahits.game.openpatrician.event.data.SwitchCity;
import ch.sahits.game.openpatrician.javafx.control.EventMediaPlayer;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.IRebinabable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DialogCloseing;
import ch.sahits.game.openpatrician.utilities.annotation.DialogOpening;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.spring.DependentAnnotationConfigApplicationContext;
import ch.sahits.game.openpatrician.utilities.spring.DialogScope;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@UniquePrototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class MainGameView
extends Group
implements IDialogContoller,
IRebinabable {
    private static final Logger logger = LogManager.getLogger(MainGameView.class);
    public static final int MINMIMAL_DISPLAY_HEIGHT = 766;
    private double controlWidth;
    private double controlHeight;
    @Autowired
    private IImageUtilities imageUtils;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private IDataImageLoader xmlLoader;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DialogFactory dialogFactory;
    private Rectangle placeHolder;
    private BaseMainGameImageView imgView;
    private Dialog dialog;
    private EventMediaPlayer eventViewer = null;
    @Autowired
    private DialogScope dialogScope;
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    @Autowired
    private SceneEventHandlerFactory sceneEventHandlerFactory;
    @Autowired
    private PolygonInitializerFactory polygonInitFactory;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    @Qualifier(value="uiTimer")
    private ScheduledExecutorService uiTimer;
    @Autowired
    private DisplayMessageOverlay dispMesgOverlay;
    @Autowired
    private DependentAnnotationConfigApplicationContext context;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private IMap map;
    private StackPane stack;
    private SeamapImageView seaMapView;

    public MainGameView(double width, double heigth) {
        this.setManaged(false);
        this.controlWidth = width;
        this.controlHeight = heigth;
    }

    @PostConstruct
    private void createComponents() {
        this.setUpImageView();
        this.sceneEventHandlerFactory.currentSceneProperty().bindBidirectional(this.currentScene);
        this.sceneEventHandlerFactory.setUpDialogController(this);
        this.polygonInitFactory.currentSceneProperty().bindBidirectional(this.currentScene);
        this.stack = new StackPane();
        this.stack.getChildren().add((Object)this.imgView);
        this.placeHolder = new Rectangle(this.controlWidth, this.controlHeight);
        this.placeHolder.setFill((Paint)Color.BLACK);
        this.dispMesgOverlay.setLayoutY(10.0);
        this.dispMesgOverlay.setLayoutX(10.0);
        this.getChildren().addAll((Object[])new Node[]{this.placeHolder, this.stack, this.dispMesgOverlay});
        this.clientEventBus.register((Object)this);
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
        this.setOnMouseClicked(event -> {
            IGame game = this.gameFactory.getGame();
            game.normalSpeed();
        });
        EventHandler closeKeyHandler = event -> {
            if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
                Platform.runLater(() -> {
                    try {
                        this.closeEventView();
                    }
                    catch (RuntimeException e) {
                        logger.error("Failed to close event view", (Throwable)e);
                    }
                });
            }
        };
        this.addEventHandler(KeyEvent.KEY_PRESSED, closeKeyHandler);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.clientServerEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    private String getImageNameFromScene() {
        switch ((EScene)((Object)this.currentScene.get())) {
            case MARKET: {
                return "images/scene/marketPlaceScene";
            }
            case PORT: {
                return "images/scene/portScene";
            }
            case SHIPYARD: {
                return "images/scene/shipYard";
            }
            case TAVERN: {
                return "images/scene/tavernIterior";
            }
            case CITY_HALL: {
                return "images/scene/cityhall";
            }
            case LOANER: {
                return "images/scene/loaner";
            }
            case CHURCH: {
                return "images/scene/churchInterior";
            }
            case GUILD: {
                return "images/scene/guildInterior";
            }
            case ARMORY: {
                return "images/scene/Armory";
            }
        }
        throw new RuntimeException(this.currentScene.get() + " is not implemented");
    }

    private void setUpImageView() {
        String imageName = this.getImageNameFromScene();
        Image tmpImg = this.xmlLoader.getImage(imageName);
        ImageData imgData = this.xmlLoader.getImageData(imageName);
        Dimension2D targetDim = new Dimension2D(this.controlWidth, this.controlHeight);
        ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
        logger.debug("State of the port scene before: " + state);
        this.imgView = new MainGameImageView(this.controlWidth, this.controlHeight, this.imageUtils.cropAndScale(imageName, state), state);
        List<Polygon> polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        this.imgView.resetPolygons(polygons);
        this.viewState.setState(EViewState.CITY);
        logger.debug("State of the port scene after : " + state);
    }

    private void setUpSeamapImageView() {
        IHumanPlayer player = this.viewState.getPlayer();
        Image mapImage = this.imageUtils.createMapWithCities(this.map, (IPlayer)player);
        Font openPatrician18 = Font.font((String)"OpenPatrician", (double)18.0);
        mapImage = this.imageUtils.addCityNames(this.map, mapImage, openPatrician18);
        Dimension2D origDim = new Dimension2D(mapImage.getWidth(), mapImage.getHeight());
        double scale = this.controlHeight / origDim.getHeight();
        Dimension2D targetDim = new Dimension2D(origDim.getWidth() * scale, origDim.getHeight() * scale);
        mapImage = this.imageUtils.scale(mapImage, targetDim, scale);
        Point2D coordinates = this.viewState.getCurrentCityProxy().get().getCity().getCoordinates();
        coordinates = new Point2D(coordinates.getX() * scale, coordinates.getY() * scale);
        if (this.seaMapView == null) {
            this.seaMapView = (SeamapImageView)((Object)this.context.getBean("seamapImageView", new Object[]{mapImage, this.controlWidth, this.controlHeight, coordinates, scale}));
        } else {
            this.seaMapView.resetImage(mapImage, this.controlWidth, this.controlHeight, scale);
        }
        this.imgView = this.seaMapView;
        this.viewState.setState(EViewState.MAP);
    }

    public void widthChange(double oldWidth, double newWidth) {
        List<Polygon> polygons = new ArrayList<Polygon>();
        Dimension2D origDim = this.map.getDimension();
        double scale = this.controlHeight / origDim.getHeight();
        if (this.imgView instanceof MainGameImageView) {
            String imageName = this.getImageNameFromScene();
            Image tmpImg = this.xmlLoader.getImage(imageName);
            ImageData imgData = this.xmlLoader.getImageData(imageName);
            Dimension2D targetDim = new Dimension2D(newWidth, this.controlHeight);
            ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
            ImageView tmpImgView = this.imageUtils.cropAndScale(imageName, state);
            ((MainGameImageView)this.imgView).setImageView(newWidth, this.controlHeight, tmpImgView, state);
            polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        }
        if (this.imgView instanceof SeamapImageView) {
            Dimension2D targetDim = new Dimension2D(origDim.getWidth() * scale, origDim.getHeight() * scale);
            IHumanPlayer player = this.viewState.getPlayer();
            Image mapImage = this.imageUtils.createMapWithCities(this.map, (IPlayer)player);
            Font openPatrician18 = Font.font((String)"OpenPatrician", (double)18.0);
            mapImage = this.imageUtils.addCityNames(this.map, mapImage, openPatrician18);
            mapImage = this.imageUtils.scale(mapImage, targetDim, scale);
            ((SeamapImageView)this.imgView).resetImage(mapImage, newWidth, this.controlHeight, scale);
        }
        this.imgView.resetPolygons(polygons);
        this.placeHolder.setWidth(newWidth);
        this.controlWidth = newWidth;
    }

    public void heightChange(double oldHeight, double newHeigth) {
        List<Polygon> polygons = new ArrayList<Polygon>();
        Dimension2D origDim = this.map.getDimension();
        double scale = newHeigth / origDim.getHeight();
        if (this.imgView instanceof MainGameImageView) {
            String imageName = this.getImageNameFromScene();
            Image tmpImg = this.xmlLoader.getImage(imageName);
            ImageData imgData = this.xmlLoader.getImageData(imageName);
            Dimension2D targetDim = new Dimension2D(this.controlWidth, newHeigth);
            ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
            ImageView tmpImgView = this.imageUtils.cropAndScale(imageName, state);
            ((MainGameImageView)this.imgView).setImageView(this.controlWidth, newHeigth, tmpImgView, state);
            polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        }
        if (this.imgView instanceof SeamapImageView) {
            Dimension2D targetDim = new Dimension2D(origDim.getWidth() * scale, origDim.getHeight() * scale);
            IHumanPlayer player = this.viewState.getPlayer();
            Image mapImage = this.imageUtils.createMapWithCities(this.map, (IPlayer)player);
            Font openPatrician18 = Font.font((String)"OpenPatrician", (double)18.0);
            mapImage = this.imageUtils.addCityNames(this.map, mapImage, openPatrician18);
            mapImage = this.imageUtils.scale(mapImage, targetDim, scale);
            ((SeamapImageView)this.imgView).resetImage(mapImage, this.controlWidth, newHeigth, scale);
        }
        this.imgView.resetPolygons(polygons);
        this.placeHolder.setHeight(newHeigth);
        this.controlHeight = newHeigth;
    }

    @Subscribe
    public void handleViewChange(ViewChangeEvent event) {
        if (event.getAddresse().equals(MainGameView.class)) {
            if (event.getEventNotice() instanceof DialogTemplate) {
                this.setNewDialog((DialogTemplate)event.getEventNotice());
            } else if (event.getEventNotice() instanceof IDialogState) {
                this.setNewDialog((IDialogState)event.getEventNotice());
            } else if (event.getEventNotice() instanceof ViewChangeCityPlayerProxyJFX && ((ViewChangeCityPlayerProxyJFX)event.getEventNotice()).getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_SEA_MAP) {
                this.currentScene.set((Object)EScene.SEAMAP);
                this.changeScene();
            } else {
                this.sceneEventHandlerFactory.getSceneEventHandler().handleEvent(event.getEventNotice());
            }
        }
    }

    @Subscribe
    public void handleDialogStateEvent(IDialogState dialogState) {
        this.setNewDialog(dialogState);
    }

    @Override
    public void replaceDialog(EDialogType dialogType, Object ... params) {
        this.closeDialog();
        while (this.dialog != null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setNewDialog(dialogType, params);
    }

    @Override
    @DialogCloseing
    public void closeDialog() {
        if (Platform.isFxApplicationThread()) {
            this.closeDialogUnwrapped();
        } else {
            Platform.runLater(this::closeDialogUnwrapped);
        }
    }

    private void closeDialogUnwrapped() {
        if (this.dialog != null) {
            this.dialog.close();
            this.context.removePrototypeBean((Object)this.dialog);
            this.getChildren().remove((Object)this.dialog);
            this.dialog = null;
            this.dialogScope.closeScope();
        } else {
            logger.warn("Tried to close the dialog but it was already null");
        }
    }

    @Override
    @DialogOpening
    public void setNewDialog(EDialogType dialogType, Object ... params) {
        if (params.length == 0) {
            this.dialog = this.dialogFactory.getDialog(dialogType, this.viewState.getCurrentCityProxy().get());
        } else if (params.length == 2) {
            if (params[0] instanceof IConvoy && params[1] instanceof IShip) {
                this.dialog = this.dialogFactory.getDialog(dialogType, this.viewState.getCurrentCityProxy().get(), (IConvoy)params[0], (IShip)params[1]);
            } else {
                throw new IllegalArgumentException("Cannot handle parameters " + params[0] + " and " + params[1]);
            }
        }
        this.dialog.setDialogType(dialogType);
        this.setNewDialog();
    }

    @Override
    @DialogOpening
    public void setNewDialog(DialogTemplate template) {
        this.closeDialogBeforeReplacing();
        this.dialog = this.dialogFactory.getDialog(template);
        this.setNewDialog();
    }

    @Override
    @DialogOpening
    public void setNewDialog(IDialogState dialogState) {
        this.closeDialogBeforeReplacing();
        this.dialog = this.dialogFactory.getDialog(dialogState);
        this.setNewDialog();
    }

    private void closeDialogBeforeReplacing() {
        while (this.dialog != null) {
            this.closeDialog();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void setNewDialog() {
        this.dialogScope.openScope();
        this.dialog.setLayoutX((this.controlWidth - 518.0) / 2.0);
        this.dialog.setLayoutY((this.controlHeight - 691.0) / 2.0);
        if (Platform.isFxApplicationThread()) {
            this.closeEventView();
            this.getChildren().add((Object)this.dialog);
        } else {
            Platform.runLater(() -> {
                this.closeEventView();
                if (this.dialog != null) {
                    this.getChildren().add((Object)this.dialog);
                }
            });
        }
    }

    @Subscribe
    public void handleEventVideoDisplay(DisplayEventVideo event) {
        if (Platform.isFxApplicationThread()) {
            this.displayEventVideoUnwrapped(event);
        } else {
            Platform.runLater(() -> this.displayEventVideoUnwrapped(event));
        }
    }

    private void displayEventVideoUnwrapped(DisplayEventVideo event) {
        this.closeEventView();
        String title = this.messageSource.getMessage(event.getTitleKey(), event.getTitleParams(), this.locale.getCurrentLocal());
        String description = this.messageSource.getMessage(event.getDescriptionKey(), event.getDescriptionParams(), this.locale.getCurrentLocal());
        this.eventViewer = new EventMediaPlayer(event.getMediaType(), (ReadOnlyDoubleProperty)new SimpleDoubleProperty(this.controlWidth));
        this.eventViewer.setTitle(title);
        this.eventViewer.setDescription(description);
        this.eventViewer.setLayoutX(0.35 * this.controlWidth / 2.0);
        this.eventViewer.setLayoutY(30.0);
        this.getChildren().add((Object)this.eventViewer);
        this.uiTimer.schedule(() -> Platform.runLater(this::closeEventView), (long)(event.getDurationInSeconds() + 5), TimeUnit.SECONDS);
    }

    private void closeEventView() {
        if (this.eventViewer != null) {
            this.eventViewer.stop();
            this.getChildren().remove((Object)this.eventViewer);
            this.eventViewer = null;
        }
    }

    @Subscribe
    public void handleGamePause(PauseGame event) {
        Platform.runLater(this::closeEventView);
    }

    @Override
    public void changeScene() {
        if (Platform.isFxApplicationThread()) {
            this.changeSceneUnwrapped();
            this.closeEventView();
        } else {
            Platform.runLater(() -> {
                this.changeSceneUnwrapped();
                this.closeEventView();
            });
        }
    }

    private void changeSceneUnwrapped() {
        this.closeDialog();
        this.stack.getChildren().removeAll((Object[])new Node[]{this.imgView});
        if (this.currentScene.get() == EScene.SEAMAP) {
            this.setUpSeamapImageView();
        } else {
            this.setUpImageView();
        }
        this.stack.getChildren().add((Object)this.imgView);
    }

    public void rebind() {
        if (this.currentScene.get() != EScene.PORT) {
            ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_PORT);
            this.handleViewChange(new ViewChangeEvent(MainGameView.class, (Object)proxy));
        }
        if (this.seaMapView != null) {
            this.seaMapView.removeShipIcons();
        }
    }

    @Subscribe
    public void handleSwitchToCity(SwitchCity event) {
        this.currentScene.set((Object)EScene.PORT);
        this.changeScene();
    }

    public Dialog getDialog() {
        return this.dialog;
    }
}

