/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.javafx.IDialogContoller;
import ch.sahits.game.openpatrician.display.javafx.ISceneEventHandler;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import com.google.common.base.Preconditions;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.HANDLER})
public class ShipyardSceneEventHandler
implements ISceneEventHandler {
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice;
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_SHIPYARD) {
                this.dialogContoller.setNewDialog(EDialogType.SHIPYARD_CONSTRUCTION, new Object[0]);
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
                this.currentScene.set((Object)EScene.PORT);
                this.dialogContoller.changeScene();
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_ARMORY) {
                this.currentScene.set((Object)EScene.ARMORY);
                this.dialogContoller.changeScene();
            }
        }
        if (eventNotice instanceof EDialogType) {
            this.dialogContoller.replaceDialog((EDialogType)eventNotice, new Object[0]);
        }
    }
}

