/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class City2StorageJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;
    @Autowired
    private TradeService tradeService;

    public City2StorageJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        int availableAmountCity = this.transfer.getCity().getWare(this.ware).getAmount();
        Optional optOffice = this.transfer.getPlayer().findTradingOffice(this.transfer.getCity());
        if (availableAmountCity > 0 && optOffice.isPresent()) {
            int amount2Move = this.transfer.getAmount(availableAmountCity);
            this.tradeService.buyFromCityToStorage((ITradingOffice)optOffice.get(), this.transfer.getPlayer(), this.transfer.getCity(), this.ware, amount2Move, Optional.empty(), Optional.empty());
        }
    }
}

