package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.SocialAdvancementDeficitState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Dialog that is used when reputation or money is not sufficient to
 * reach the next social rank.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 10, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class SocialAdvancementDeficitDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;

    private SocialAdvancementDeficitState state;

    public SocialAdvancementDeficitDialog(SocialAdvancementDeficitState state) {
        super(true);
        this.state = state;
    }
    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        if (state.isReputation() && state.isMoney()) {
            addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.missingReputationAndWealth", "missingReputationAndWealth", state.getLocation());
        } else if (state.isMoney()) {
            addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.missingMoney", "missingMoney", state.getLocation());
        } else {
            addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.SocialAdvancementDeficitDialog.missingReputation", "missingReputation", state.getLocation());
        }
    }
}
