package ch.sahits.game.openpatrician.display.dialog.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.MapProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

/**
 * Utility class for the tavern dialog. Contains functionality that
 * is shared by multiple dialogs, which do not have the same parent.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 26, 2013
 */
@Service
@Lazy
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class TavernDialogUtil {
    public void stopTalkingToPerson(TavernState tavernState, IPlayer player) {
        final MapProperty<IPerson,IPlayer> iPersonIPlayerMapProperty = tavernState.talkingToProperty();
        Map<IPerson, IPlayer> talkTo = iPersonIPlayerMapProperty.get();
        // Do not replace with foreach for testability
        for (Iterator<Entry<IPerson, IPlayer>> iterator = talkTo.entrySet().iterator(); iterator.hasNext(); ) {
            Map.Entry<IPerson, IPlayer> entry = iterator.next();
            if (entry.getValue().equals(player)) {
                iterator.remove(); // stoped talking
            }
        }
    }
    /**
     * Check if there is a ship with enough capacity to load the ware onto.
     * @param city city proxy containing the players ship currently in port
     * @param amountInBale amount that should be available in bales
     * @return true if the required capacity is <strong>not</strong> available on any ship
     */
    public boolean noShipWithEnoughCapacityAvailable(ICityPlayerProxyJFX city, int amountInBale) {
        if (city.getPlayersShips().isEmpty()) {
            return true; // no ship available => disable
        }
        for (IShip ship : city.getPlayersShips()) {
            if (ship.getCapacity() >= amountInBale*10) {
                return false; // ship found with enough capacity
            }
        }
        return true;
    }
}
