package ch.sahits.game.openpatrician.display.dialog.ship;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Dialog displaying the ship info for the current selected ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Sep 30, 2017
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipInfoDialog extends CloseButtonDialog {   // TODO: andi 4/11/18 rename to weapons info 
    /** Reference to the proxy view model */
    private final ICityPlayerProxyJFX proxy;

    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;

    public ShipInfoDialog(ICityPlayerProxyJFX proxy) {
        this.proxy = proxy;
    }

    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.title",  // TODO: andi 4/11/18 rename 
                new Object[]{}, locale.getCurrentLocal()));

        ObjectProperty<IShip> shipProperty = new SimpleObjectProperty<>((IShip) proxy.getActiveShip());
        ObjectBinding<IShip> shipBinding = shipBinding();
        shipProperty.bind(shipBinding);

        GridPane shipInfo = dialogUtil.createShipInfoOnThreeLines(shipProperty);
        shipInfo.setId("shipInfo");
        shipInfo.setLayoutY(100);
        shipInfo.setLayoutX(INSET);
        Pane weaponPane = dialogUtil.createShipWeaponDisplay(shipProperty.get());
        weaponPane.setId("weaponPane");
        weaponPane.setScaleX(0.5);
        weaponPane.setScaleY(0.5);
        weaponPane.setLayoutX(-270 + INSET);
        weaponPane.setLayoutY(100);
        shipBinding.addListener((observable, oldValue, newValue) -> {
            getContent().remove(getContent().size() - 1);
            Pane pane = dialogUtil.createShipWeaponDisplay(newValue);
            pane.setId("weaponPane");
            pane.setScaleX(0.5);
            pane.setScaleY(0.5);
            pane.setLayoutX(-270 + INSET);
            pane.setLayoutY(100);
            getContent().add(pane);
        });
        getContent().addAll(shipInfo, weaponPane);
    }

    private ObjectBinding<IShip> shipBinding() {
        return new ObjectBinding<>() {
            {
                super.bind(proxy.activeShipProperty());
            }

            @Override
            protected IShip computeValue() {
                INavigableVessel vessel = proxy.getActiveShip();
                if (vessel instanceof IShip) {
                    return (IShip) vessel;
                } else {
                    executeOnCloseButtonClicked();
                    return null;
                }
            }
        };
    }
}
