package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.CityCreditor;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.impl.Debt;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class DelayedCaughtAction extends TimedTask implements IDelayedCaughtAction {
    private final IPlayer player;
    private final ICity city;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    private LoanerList loaners;

    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;
    public DelayedCaughtAction(IPlayer player, ICity city) {
        super();
        this.player = player;
        this.city = city;
    }
    @PostConstruct
    private void initialize() {
        setExecutionTime(date.getCurrentDate().plusDays(5));
    }

    @Override
    public void run() {
        int penalty = (int)(Math.abs(player.getCompany().getCash()/(200*rnd.nextDouble())));
        DisplayMessage msg = new DisplayMessage("ch.sahits.game.graphic.event.task.DelayedCaughtAction.message", penalty);
        clientEventBus.post(msg);
        ILoaner loaner = loaners.getLoaner(city);
        IDebt debt = Debt.builder()
                .amount(penalty)
                .dueDate(date.getCurrentDate().plusMonths(1))
                .interest(0)
                .loanTakeOut(date.getCurrentDate())
                .debitor(player)
                .creditor(new CityCreditor())
                .build();
        loaner.addDebt(debt);
    }
}
