package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

import java.time.LocalDateTime;

/**
 * Timed task for the warehouse tenant removing the wares from the warehouse.
 * Created by andi on 26.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WarehouseTenantPayTimedTask extends TimedTask {
    private IPlayer player;
    private IWarehouseTenant tenant;

    public WarehouseTenantPayTimedTask(IPlayer player, IWarehouseTenant tenant, LocalDateTime deadLine) {
        this.player = player;
        this.tenant = tenant;
        setExecutionTime(deadLine);
    }

    @Override
    public void run() {
        if (player instanceof IHumanPlayer) {
            player.getCompany().updateCash(tenant.getRentPerWeek());
        } else {
            player.getCompany().updateCashDirectly(tenant.getRentPerWeek());
        }

    }
}
