/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.BuildingProduction;
import ch.sahits.game.openpatrician.clientserverinterface.service.CityProductionAndConsumptionService;
import ch.sahits.game.openpatrician.display.dialog.TabelViewDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.BaleAmount;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmount;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityProductionConsumptionDialog
extends TabelViewDialog {
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private BuildingProduction buildingProduction;
    @Autowired
    private PopulationConsume consumer;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private CityProductionAndConsumptionService cityProductionAndConsumptionService;

    public CityProductionConsumptionDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog.prodCon", new Object[0], this.locale.getCurrentLocal()));
        Group subTitle = this.createSubTitle();
        subTitle.setLayoutX(30.0);
        subTitle.setLayoutY(80.0);
        this.getContent().add((Object)subTitle);
        Table model = this.createModel();
        this.setModel(model);
    }

    private Group createSubTitle() {
        Group g = new Group();
        g.setManaged(false);
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog.weekly", new Object[0], this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        StackPane titlePane = new StackPane();
        titlePane.getChildren().addAll((Object[])new Node[]{new PlaceHolder(518.0, 1.0), text});
        g.getChildren().add((Object)titlePane);
        return g;
    }

    private Table createModel() {
        Table model = new Table();
        TableHeader header = new TableHeader(7);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog.stock", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.city", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog.shops", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog.pop", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog.shops", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog.tot", new Object[0], this.locale.getCurrentLocal())));
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.RIGHT);
        model.setAligenment(5, HPos.RIGHT);
        model.setAligenment(6, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{70, 60, 60, 60, 60, 60, 60});
        for (EWare ware : EWare.values()) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            ReadOnlyIntegerProperty amountAvailableProp = this.city.getCity().getWare((IWare)ware).amountProperty();
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = new BarrelAmount();
                barrelAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmount baleAmount = new BaleAmount();
                baleAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            int producedAmount = this.calculateProducedWares((IWare)ware);
            this.addAmountCell(ware, row, producedAmount);
            int chandlerProduction = this.buildingProduction.getTotalProduction((IWare)ware, this.city.getCity());
            this.addAmountCell(ware, row, chandlerProduction);
            int popConsumption = this.computeCitizenConsumtion((IWare)ware);
            this.addAmountCell(ware, row, popConsumption);
            int consumeShops = this.buildingProduction.getTotalConsumtion((IWare)ware, this.city.getCity());
            this.addAmountCell(ware, row, consumeShops);
            int consumeTot = consumeShops;
            this.addAmountCell(ware, row, consumeTot += this.computeCitizenConsumtion((IWare)ware));
            model.add(row);
        }
        return model;
    }

    private void addAmountCell(EWare ware, TableRow row, int popConsumption) {
        if (ware.isBarrelSizedWare()) {
            BarrelAmount barrelAmount = new BarrelAmount();
            barrelAmount.setAmount(Integer.valueOf(popConsumption));
            row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
        } else {
            BaleAmount baleAmount = new BaleAmount();
            baleAmount.setAmount(Integer.valueOf(popConsumption));
            row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        }
    }

    private int calculateProducedWares(IWare ware) {
        return this.cityProductionAndConsumptionService.getProductionOutputCurrentWeek(ware, this.city.getCity());
    }

    private boolean contains(IWare[] array, IWare item) {
        for (IWare ware : array) {
            if (ware != item) continue;
            return true;
        }
        return false;
    }

    private int computeCitizenConsumtion(IWare ware) {
        double amount = this.consumer.getNeed(ware, EPopulationClass.POOR, this.city.getCity().getPopulation(EPopulationClass.POOR));
        amount += this.consumer.getNeed(ware, EPopulationClass.MEDIUM, this.city.getCity().getPopulation(EPopulationClass.MEDIUM));
        return (int)Math.rint(amount += this.consumer.getNeed(ware, EPopulationClass.RICH, this.city.getCity().getPopulation(EPopulationClass.RICH)));
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

