/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityStorageTradeDialog
extends BaseTradeDialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public CityStorageTradeDialog(ICityPlayerProxyJFX city) {
        super(city, EDialogType.PORT_CITY_TO_STORAGE);
    }

    @Override
    protected String getTradeToDestination() {
        return this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected Group createSubTitle(final ICityPlayerProxyJFX city) {
        StringBinding cityPopulation = new StringBinding(){
            {
                super.bind(new Observable[]{city.getCity().getPopulationBinding()});
            }

            protected String computeValue() {
                ICity actualCity = city.getCity();
                return actualCity.getName() + " " + actualCity.getPopulationBinding().asString().get();
            }
        };
        Text cityText = new Text();
        cityText.textProperty().bind((ObservableValue)cityPopulation);
        cityText.getStyleClass().add((Object)"dialogText");
        Group g = new Group();
        g.setManaged(false);
        final Optional optOffice = city.getPlayer().findTradingOffice(city.getCity());
        BarrelIconView barrel = new BarrelIconView();
        barrel.setLayoutX(174.0);
        barrel.setLayoutY(-12.0);
        StringBinding storageLoad = new StringBinding(){
            {
                optOffice.ifPresent(iTradingOffice -> {
                    ITradingOffice office = iTradingOffice;
                    super.bind(new Observable[]{office.storedAmountBinding(), office.capacityProperty()});
                });
            }

            protected String computeValue() {
                if (optOffice.isPresent()) {
                    ITradingOffice office = (ITradingOffice)optOffice.get();
                    return office.storedAmountBinding().asString().get() + " / " + office.capacityProperty().get();
                }
                return "0 / 0";
            }
        };
        Text shipSpace = new Text();
        shipSpace.textProperty().bind((ObservableValue)storageLoad);
        shipSpace.getStyleClass().add((Object)"dialogText");
        shipSpace.setLayoutX(200.0);
        Text shipName = new Text(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal()));
        shipName.getStyleClass().add((Object)"dialogText");
        shipName.setLayoutX(300.0);
        g.getChildren().addAll((Object[])new Node[]{cityText, barrel, shipSpace, shipName});
        return g;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

