/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.church;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.event.PostponedDisplayDialogMessage;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ChurchFeedingDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ICityPlayerProxyJFX city;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientTaskFactory taskFactory;
    private int numberOfColumns;
    private int mainTableYPosition;
    private final ITradingOffice office;
    private static final EWare[] MATERIALS = new EWare[]{EWare.GRAIN, EWare.MEAT, EWare.FISH, EWare.BEER, EWare.WINE};
    @MapType(key=IWare.class, value=IntegerProperty.class)
    private ObservableMap<IWare, IntegerProperty> availableMap = FXCollections.observableMap(new HashMap());

    public ChurchFeedingDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        List offices = city.getCity().findBuilding(ITradingOffice.class, Optional.of(city.getPlayer()));
        this.office = offices.isEmpty() ? null : (ITradingOffice)offices.get(0);
        this.mainTableYPosition = 286;
        this.clearMap();
    }

    private void clearMap() {
        for (EWare ware : MATERIALS) {
            this.availableMap.put((Object)ware, (Object)new SimpleIntegerProperty(0));
        }
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.title", new Object[0], this.locale.getCurrentLocal()));
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.introText", new Object[0], this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        VBox box = new VBox(new Node[]{text});
        Table mainTable = this.createMainTable();
        GridPane mainTablePane = new GridPane();
        mainTablePane.setLayoutX(30.0);
        mainTablePane.setLayoutY((double)this.mainTableYPosition);
        RowConstraints rowConstraint = this.getRowConstraints();
        mainTablePane.getRowConstraints().add((Object)rowConstraint);
        TableHeader header = mainTable.getHeader();
        this.numberOfColumns = mainTable.getNumberOfColumns();
        int currentCol = 0;
        for (int i = 0; i < this.numberOfColumns && header.size() > 0; ++i) {
            int colWidth = mainTable.getColumnWidth(i);
            ColumnConstraints colConstraint = new ColumnConstraints((double)colWidth);
            colConstraint.setHalignment(header.getAligenment(i));
            mainTablePane.getColumnConstraints().add((Object)colConstraint);
            ITableCell cell = header.get(i);
            String textStyleClass = "tableHeader";
            this.fxUtils.addCellToGridPane(mainTablePane, -1, null, currentCol++, cell, header.getAligenment(i), "tableHeader");
        }
        for (int rowNum = 0; rowNum < mainTable.getNumberOfRows(); ++rowNum) {
            TableRow row = mainTable.get(rowNum);
            mainTablePane.getRowConstraints().add((Object)rowConstraint);
            int iterationLimit = Math.min(mainTable.getNumberOfColumns(), row.size());
            for (int col = 0; col < iterationLimit; ++col) {
                ITableCell cell = row.get(col);
                HPos hAlignment = mainTable.getAligenment(col);
                String textStyleClass = "tableCell";
                this.fxUtils.addCellToGridPane(mainTablePane, rowNum, row, col, cell, hAlignment, "tableCell");
            }
        }
        mainTablePane.getStyleClass().add((Object)"tableFont");
        box.setLayoutX(50.0);
        box.setLayoutY(127.0);
        box.getChildren().addAll((Object[])new Node[]{mainTablePane});
        int actionButtonX = 197;
        String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.donate", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
        action.getStyleClass().add((Object)"actionButton");
        action.setOnAction(this.getAction());
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        BooleanBinding actionEnabled = this.actionEnabledBinding();
        action.setDisable(!actionEnabled.get());
        actionEnabled.addListener((observableValue, oldValue, newValue) -> action.setDisable(newValue == false));
        this.getContent().addAll((Object[])new Node[]{box, action});
    }

    private BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                if (ChurchFeedingDialog.this.availableMap.isEmpty()) {
                    return false;
                }
                for (IntegerProperty amount : ChurchFeedingDialog.this.availableMap.values()) {
                    if (amount.get() <= 0) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private EventHandler<MouseEvent> getAction() {
        return evt -> {
            try {
                int amountBeggers = this.rnd.nextInt(this.city.getCity().getPopulationBinding().get() / 70);
                int amountWares = 0;
                for (IWare ware : this.availableMap.keySet()) {
                    amountWares += ((IntegerProperty)this.availableMap.get((Object)ware)).get() * ware.getSizeAsBarrels();
                }
                boolean sufficient = amountBeggers * 5 <= amountWares;
                LocalDateTime execution = this.date.getCurrentDate().plusDays(this.rnd.nextInt(30));
                Object[] args = new Object[]{amountBeggers};
                if (sufficient) {
                    DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.successfulFeedingTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.successfulFeeding").messageArgs(args).build();
                    Object task = this.taskFactory.getPostponedDisplayDialogMessage(execution, template);
                    this.timedTaskListener.add((TimedTask)task);
                    task = this.taskFactory.getReputationUpdateTaskChurchFeeding(this.city.getCity(), (IPlayer)this.city.getPlayer(), amountBeggers, execution);
                    this.timedTaskListener.add((TimedTask)task);
                } else {
                    DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.unsuccessfulFeedingTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.unsuccessfulFeeding").messageArgs(args).build();
                    PostponedDisplayDialogMessage task = this.taskFactory.getPostponedDisplayDialogMessage(execution, template);
                    this.timedTaskListener.add((TimedTask)task);
                }
                this.availableMap.clear();
                this.city.getCity().getCityState().getPopUpdateStatistic().feedingThePoor();
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to order feeding of the poor", (Throwable)e);
            }
        };
    }

    private Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal());
        header.add((ITableCell)new StaticTextTableCell(s));
        s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal());
        header.add((ITableCell)new StaticTextTableCell(s));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog.donation", new Object[0], this.locale.getCurrentLocal());
        header.add((ITableCell)new StaticTextTableCell(s));
        header.setAligenment(0, HPos.LEFT);
        header.setAligenment(1, HPos.CENTER);
        header.setAligenment(4, HPos.LEFT);
        model.setHeader(header);
        model.setAligenment(0, HPos.LEFT);
        model.setAligenment(1, HPos.CENTER);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.CENTER);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 70});
        for (final EWare ware : MATERIALS) {
            SimpleIntegerProperty stored;
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            Object object = stored = this.office != null ? this.office.getWare((IWare)ware).amountProperty() : new SimpleIntegerProperty(0);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            BooleanBinding removeEnabled = new BooleanBinding(){
                {
                    super.bind(new Observable[]{ChurchFeedingDialog.this.availableMap});
                }

                protected boolean computeValue() {
                    return ChurchFeedingDialog.this.availableMap.get((Object)ware) == null || ((IntegerProperty)ChurchFeedingDialog.this.availableMap.get((Object)ware)).get() <= 0;
                }
            };
            BooleanBinding donateEnabled = Bindings.lessThan((int)1, (ObservableNumberValue)stored).not();
            OpenPatricianSmallWaxButton previous = new OpenPatricianSmallWaxButton("<");
            previous.getStyleClass().add((Object)"actionButton");
            previous.setOnAction(this.createPreviousAction(ware));
            previous.disableProperty().bind((ObservableValue)removeEnabled);
            row.add((ITableCell)new ControlTableCell((Node)previous));
            OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton(">");
            next.getStyleClass().add((Object)"actionButton");
            next.setOnAction(this.createNextAction(ware));
            next.disableProperty().bind((ObservableValue)donateEnabled);
            row.add((ITableCell)new ControlTableCell((Node)next));
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.setAmount(Integer.valueOf(0));
                this.availableMap.addListener(change -> {
                    IntegerProperty valueAdded = (IntegerProperty)change.getValueAdded();
                    if (ware.equals(change.getKey()) && valueAdded != null) {
                        barrelAmount.amountProperty().setValue(String.valueOf(valueAdded.get()));
                    }
                });
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.setAmount(Integer.valueOf(0));
                this.availableMap.addListener(change -> {
                    IntegerProperty valueAdded = (IntegerProperty)change.getValueAdded();
                    if (ware.equals(change.getKey()) && valueAdded != null) {
                        baleAmount.amountProperty().setValue(String.valueOf(valueAdded.get()));
                    }
                });
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            model.add(row);
        }
        return model;
    }

    private EventHandler<MouseEvent> createNextAction(EWare ware) {
        return evt -> {
            try {
                this.office.move((IWare)ware, -1);
                IntegerProperty donated = (IntegerProperty)this.availableMap.get((Object)ware);
                this.availableMap.put((Object)ware, (Object)new SimpleIntegerProperty(donated.add(1).intValue()));
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to move wares", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> createPreviousAction(EWare ware) {
        return evt -> {
            try {
                this.office.move((IWare)ware, 1);
                IntegerProperty donated = (IntegerProperty)this.availableMap.get((Object)ware);
                this.availableMap.put((Object)ware, (Object)new SimpleIntegerProperty(donated.subtract(1).intValue()));
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to move wares", (Throwable)e);
            }
        };
    }

    private RowConstraints getRowConstraints() {
        RowConstraints rowConstraint = new RowConstraints(24.0);
        return rowConstraint;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        for (IWare ware : this.availableMap.keySet()) {
            IntegerProperty amount = (IntegerProperty)this.availableMap.get((Object)ware);
            this.office.move(ware, amount.intValue(), 0);
        }
        this.availableMap.clear();
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_CHURCH);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    @VisibleForTesting
    int getAmountDonated(IWare ware) {
        return ((IntegerProperty)this.availableMap.get((Object)ware)).get();
    }
}

