/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.shipyard;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipyardConstructionListDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.SINGLETON_BEAN})
public class ShipyardConstructionListDialogV2
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=IShipDueDate.class)
    private final ObjectProperty<IShipDueDate> selectedShip;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations modelTranslator;
    private GridPane grid;

    public ShipyardConstructionListDialogV2(ICityPlayerProxyJFX city) {
        this.city = city;
        this.selectedShip = new SimpleObjectProperty((Object)this, "selectedShip", null);
    }

    @PostConstruct
    private void initializeComponents() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionListDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
        IShipyard state = this.city.getCity().getCityState().getShipyardState();
        List shipBuildingList = state.getShipBuildingList();
        if (shipBuildingList.isEmpty()) {
            String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionListDialogV2.noShipsBuilding", new Object[0], this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(s, new HashMap());
            text.setLayoutY(100.0);
            this.getContent().addAll((Object[])new Node[]{text});
        } else {
            Comparator comparator = (dueDate1, dueDate2) -> dueDate1.getDueDate().compareTo(dueDate2.getDueDate());
            shipBuildingList.sort(comparator);
            this.grid = new GridPane();
            this.grid.setLayoutX(30.0);
            this.grid.setLayoutY(100.0);
            String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionListDialogV2.dueDate", new Object[0], this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(s, new HashMap());
            this.grid.add((Node)text, 0, 0);
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
            s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionListDialogV2.owner", new Object[0], this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(s, new HashMap());
            this.grid.add((Node)text, 1, 0);
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints(250.0));
            s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionListDialogV2.shipType", new Object[0], this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(s, new HashMap());
            this.grid.add((Node)text, 2, 0);
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
            for (int row = 1; row <= shipBuildingList.size(); ++row) {
                int index = row - 1;
                IShipDueDate dueDate = (IShipDueDate)shipBuildingList.get(index);
                LocalDateTime time = dueDate.getDueDate();
                IShip ship = dueDate.getShip();
                IPlayer owner = (IPlayer)ship.getOwner();
                boolean isOwnedByPlayer = owner.equals(this.city.getPlayer());
                Text text1 = new Text(this.modelTranslator.toDisplayString(time));
                text1.setId("date-" + index);
                text1.getStyleClass().add((Object)"dialogText");
                text1.setLayoutY(15.0);
                Pane col1 = new Pane();
                col1.getChildren().add((Object)text1);
                this.grid.add((Node)col1, 0, row);
                Text text2 = new Text(owner.getName() + " " + owner.getLastName());
                text2.setId("name-" + index);
                text2.getStyleClass().add((Object)"dialogText");
                text2.setLayoutY(15.0);
                Pane col2 = new Pane();
                col2.getChildren().add((Object)text2);
                this.grid.add((Node)col2, 1, row);
                Text text3 = new Text(this.modelTranslator.getLocalDisplayName(ship.getShipType()));
                text3.setId("shipType-" + index);
                text3.getStyleClass().add((Object)"dialogText");
                text3.setLayoutY(15.0);
                Pane col3 = new Pane();
                col3.getChildren().add((Object)text3);
                this.grid.add((Node)col3, 2, row);
                SelectLineEventHandler selectionLineEventHandler = new SelectLineEventHandler(dueDate, new Pane[]{col1, col2, col3});
                if (!isOwnedByPlayer) continue;
                text1.setOnMouseReleased((EventHandler)selectionLineEventHandler);
                text2.setOnMouseReleased((EventHandler)selectionLineEventHandler);
                text3.setOnMouseReleased((EventHandler)selectionLineEventHandler);
            }
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionListDialogV2.cancel", new Object[0], this.locale.getCurrentLocal()));
            action.getStyleClass().add((Object)"actionButton");
            action.setId("action");
            action.setOnAction(mouseEvent -> {
                try {
                    state.cancelShipBuildingOrder(((IShipDueDate)this.selectedShip.get()).getDueDate());
                    this.executeOnCloseButtonClicked();
                }
                catch (RuntimeException e) {
                    this.logger.error("Failed to accept meeting", (Throwable)e);
                }
            });
            int actionButtonX = 197;
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            BooleanBinding actionEnabled = new BooleanBinding(){

                protected boolean computeValue() {
                    return ShipyardConstructionListDialogV2.this.selectedShip.get() != null;
                }
            };
            action.setDisable(true);
            actionEnabled.addListener((observableValue, oldValue, newValue) -> action.setDisable(newValue == false));
            this.getContent().addAll((Object[])new Node[]{this.grid, action});
        }
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    private class SelectLineEventHandler
    implements EventHandler<MouseEvent> {
        private final IShipDueDate ship;
        private final List<Pane> row;

        private SelectLineEventHandler(IShipDueDate ship, Pane ... row) {
            this.ship = ship;
            this.row = Arrays.asList(row);
        }

        public void handle(MouseEvent mouseEvent) {
            try {
                ShipyardConstructionListDialogV2.this.selectedShip.set((Object)this.ship);
                for (Node node : ShipyardConstructionListDialogV2.this.grid.getChildren()) {
                    if (this.row.contains(node)) {
                        node.setStyle("-fx-background-color: grey");
                        continue;
                    }
                    node.setStyle("-fx-background-color: transparent");
                }
            }
            catch (RuntimeException e) {
                ShipyardConstructionListDialogV2.this.logger.error("Failed to select ship", (Throwable)e);
            }
        }
    }
}

