/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernInformantDialogPageTwo
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final IInformant informant;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private final TavernState tavernState;

    public TavernInformantDialogPageTwo(ICityPlayerProxyJFX city) {
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.informant = this.tavernState.getInformant();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageOne.title", new Object[]{this.informant.getName()}, this.locale.getCurrentLocal()));
        StringBuilder template = new StringBuilder();
        HashMap parameters = new HashMap();
        if (this.informant.getWareNeeded().isPresent()) {
            GenericPair needed = (GenericPair)this.informant.getWareNeeded().get();
            template.append(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog1", new Object[]{((ICity)needed.getFirst()).getName(), this.translator.getLocalDisplayName((EWare)needed.getSecond())}, this.locale.getCurrentLocal()));
        }
        if (this.informant.getWareSurplus().isPresent()) {
            GenericPair surplus = (GenericPair)this.informant.getWareSurplus().get();
            template.append(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog2", new Object[]{((ICity)surplus.getFirst()).getName(), this.translator.getLocalDisplayName((EWare)surplus.getSecond())}, this.locale.getCurrentLocal()));
        }
        Optional mapSectionPart = this.informant.getMapSectionPart((IPlayer)this.city.getPlayer());
        mapSectionPart.ifPresent(mapSegmentedImage -> {
            ArrayList visibleSegs = new ArrayList(mapSegmentedImage.getSegmentIndices());
            parameters.put("visibleSegments", visibleSegs);
            template.append(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog4", new Object[]{mapSegmentedImage.getImageName()}, this.locale.getCurrentLocal()));
        });
        if (this.informant.getPirateLocation().isPresent()) {
            GenericPair pirate = (GenericPair)this.informant.getPirateLocation().get();
            template.append(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernInformantDialogPageTwo.dialog3", new Object[]{pirate.getFirst(), ((ICity)pirate.getSecond()).getName()}, this.locale.getCurrentLocal()));
        }
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(template.toString(), parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }
}

