/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.display.event.handler.impl.WaitTimeForShipArrivalInCity;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class DeliverPackages
extends WaitTimeForShipArrivalInCity {
    private final int amount;
    private final int premium;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    public DeliverPackages(ICity city, IShip ship, LocalDateTime deadline, int premium, int amount) {
        super(city, (INavigableVessel)ship, deadline);
        this.premium = premium;
        this.amount = amount;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public boolean execute(ICity city) {
        ((IShip)this.getShip()).setOccupiedSpace(((IShip)this.getShip()).getOccupiedSpace() - this.amount);
        IPlayer owner = (IPlayer)this.getShip().getOwner();
        if (this.rnd.nextBoolean()) {
            int penalty = (int)Math.abs((double)(owner.getCompany().getCash() / 200L) * this.rnd.nextDouble());
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageCaught", new Object[]{penalty});
            this.clientEventBus.post((Object)msg);
            if (owner instanceof IHumanPlayer) {
                owner.getCompany().updateCash((long)(-penalty));
            } else {
                owner.getCompany().updateCashDirectly((long)(-penalty));
            }
        } else {
            if (owner instanceof IHumanPlayer) {
                owner.getCompany().updateCash((long)this.premium);
            } else {
                owner.getCompany().updateCashDirectly((long)this.premium);
            }
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageSuccess", new Object[0]);
            this.clientEventBus.post((Object)msg);
        }
        this.unregisterEventBus();
        return false;
    }

    @Override
    public void destroy() {
        ((IShip)this.getShip()).setOccupiedSpace(((IShip)this.getShip()).getOccupiedSpace() - this.amount);
        super.destroy();
    }
}

