/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISailors;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import javafx.collections.ObservableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
class TavernDialogChangeAction
implements Runnable {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    private final IPerson showingPerson;
    private final TavernState tavernState;
    private final IPlayer player;
    private final EDialogType dialogType;

    public TavernDialogChangeAction(IPerson showingPerson, TavernState tavernState, IPlayer currentPlayer, EDialogType dialogType) {
        this.showingPerson = showingPerson;
        this.tavernState = tavernState;
        this.player = currentPlayer;
        this.dialogType = dialogType;
    }

    @Override
    public void run() {
        boolean doUpdate = this.dialogType != null;
        boolean canTalkToOnlyOnePerson = true;
        if (this.showingPerson instanceof ISailors) {
            canTalkToOnlyOnePerson = false;
        }
        if (this.showingPerson instanceof IWeaponsDealer) {
            canTalkToOnlyOnePerson = false;
        }
        if (doUpdate) {
            if (canTalkToOnlyOnePerson) {
                ((ObservableMap)this.tavernState.talkingToProperty().get()).put((Object)this.showingPerson, (Object)this.player);
            }
            this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)this.dialogType));
        }
    }
}

