/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx;

import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;

public abstract class BaseMainGameImageView
extends Group {
    protected boolean withPolygonShading = false;
    private Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.PINK};

    public BaseMainGameImageView() {
        if (System.getProperty("javafx.polygon.shading") != null) {
            this.withPolygonShading = true;
        }
        this.setManaged(false);
    }

    public void resetPolygons(List<Polygon> polygons) {
        ImageView imageView = this.getImageView();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon polygon = polygons.get(i);
            if (imageView != null) {
                polygon.setLayoutX(imageView.getLayoutX());
                polygon.setLayoutY(imageView.getLayoutY());
            }
            if (this.withPolygonShading) {
                polygon.setFill((Paint)this.colors[i % this.colors.length]);
                polygon.setOpacity(0.5);
            } else {
                polygon.setFill((Paint)Color.TRANSPARENT);
            }
            this.getChildren().add((Object)polygon);
        }
    }

    private ImageView getImageView() {
        for (Node node : this.getChildren()) {
            if (!(node instanceof ImageView)) continue;
            return (ImageView)node;
        }
        return null;
    }
}

