/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.event.data.ResumeGame;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.GameFactory;
import ch.sahits.game.openpatrician.display.SceneChangeable;
import ch.sahits.game.openpatrician.display.scene.BaseStartupScene;
import ch.sahits.game.openpatrician.display.scene.MainGameScene;
import ch.sahits.game.openpatrician.display.scene.SceneChangeService;
import ch.sahits.game.openpatrician.display.service.GameOptionsService;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.event.data.IGameStateChangeData;
import ch.sahits.game.openpatrician.event.data.NewGame;
import ch.sahits.game.openpatrician.javafx.OpenPatricianScene;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@UniquePrototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class LoadGameScene
extends BaseStartupScene {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GameOptionsService gameOptions;
    @Autowired
    private Date gameDate;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private SceneChangeService sceneChanger;
    private SceneChangeable sceneChangeable;
    private OpenPatricianSpinner lodableGames;

    public LoadGameScene() {
        super((Region)new StackPane());
        this.getRoot().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(this.getStyleSheetFilename()).toExternalForm());
    }

    @Override
    public SceneChangeable getSceneChangeable() {
        return this.sceneChangeable;
    }

    @Override
    public void setSceneChangeable(SceneChangeable sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }

    @Override
    protected String getStyleSheetFilename() {
        return "newGame.css";
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @PostConstruct
    private void createControls() {
        this.gameFactory.getGame();
        StackPane root = (StackPane)this.getRoot();
        root.setId("LoadGameStackPane");
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        grid.setAlignment(Pos.CENTER);
        grid.getColumnConstraints().add((Object)new ColumnConstraints(200.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(300.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(250.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        Label loadLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)loadLbl, 0, 0);
        this.lodableGames = new OpenPatricianSpinner();
        this.lodableGames.selectedIndexProperty().setValue((Number)0);
        this.lodableGames.getStyleClass().add((Object)"defaultTextSize24");
        this.lodableGames.setMaxWidth(200.0);
        grid.add((Node)this.lodableGames, 1, 0);
        GridPane.setHalignment((Node)this.lodableGames, (HPos)HPos.LEFT);
        this.lodableGames.setOptions(FXCollections.observableArrayList(this.gameOptions.getSavegames()));
        this.lodableGames.setMaxWidth(250.0);
        OpenPatricianStoneButton loadBtn = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()));
        loadBtn.getStyleClass().add((Object)"defaultTextSize24");
        grid.add((Node)loadBtn, 3, 0);
        GridPane.setHalignment((Node)loadBtn, (HPos)HPos.LEFT);
        loadBtn.setOnAction(this.createLoadAction());
        root.getChildren().add((Object)grid);
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void handleGameStateChange(GameStateChange stateChange) {
        if (stateChange.getStatusChange() == EGameStatusChange.GAME_INITIALISATION_COMPLETE) {
            this.logger.info("Load and replace the game");
            this.gameOptions.load(this.lodableGames.getSelectedValue());
        }
        if (stateChange.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            this.uiFactory.invalidate();
            MainGameScene mainGameScene1 = this.uiFactory.getMainGameScene(this.getRoot().getWidth(), this.getRoot().getHeight());
            mainGameScene1.initializeGameView(null);
            Platform.runLater(() -> this.changeScene(mainGameScene1));
            this.timerEventBus.post((Object)new ResumeGame());
        }
    }

    private EventHandler<MouseEvent> createLoadAction() {
        return event -> {
            try {
                NewGame newGameDTO = NewGame.builder().difficulty(Difficulty.CHANDLER).firstName("FirstName").lastName("Lastname").hometown("BREMEN").objective(EObjective.ENDLESS).speed(EGameSpeed.SLOW).startYear(1300).male(true).mapName("/standartHanseaticMap.xml").environmentInitialisation(true).build();
                this.gameDate.setStartYear(0);
                double width = this.getRoot().getWidth();
                double height = this.getRoot().getHeight();
                this.logger.debug("Change into main game scene with dimensions: {}x{}", (Object)width, (Object)height);
                MainGameScene mainGameScene = this.uiFactory.getMainGameScene(width, height);
                mainGameScene.initializeGameView(null);
                GameStateChange stateChange = new GameStateChange(EGameStatusChange.LOAD_GAME_INIT);
                stateChange.setStateChangeData((IGameStateChangeData)newGameDTO);
                this.clientServerEventBus.post((Object)stateChange);
                while (this.gameDate.getStartYear() == null) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        this.logger.warn("Interrupted while waiting for the startyear to be set.");
                    }
                }
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to load new game", (Throwable)e);
            }
        };
    }

    @Override
    public void changeScene(OpenPatricianScene scene) {
        this.sceneChanger.changeScene(this.sceneChangeable, scene);
    }
}

