/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.openpatrician.data.xmlmodel.map.Map;
import ch.sahits.game.openpatrician.display.IOpenPatricianApplicationWindow;
import ch.sahits.game.openpatrician.display.SceneChangeable;
import ch.sahits.game.openpatrician.display.scene.SceneChangeService;
import ch.sahits.game.openpatrician.display.service.GameOptionsService;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.event.data.IGameStateChangeData;
import ch.sahits.game.openpatrician.event.data.NewGame;
import ch.sahits.game.openpatrician.javafx.OpenPatricianScene;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianRadioButton;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSlider;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.openpatrician.javafx.model.OpenPatricianSpinnerOptionDataModel;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.city.EKontorType;
import ch.sahits.game.openpatrician.model.server.MapProviderService;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.service.RandomNameLoader;
import com.google.common.eventbus.AsyncEventBus;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.oxm.Unmarshaller;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class NewGameScene
extends OpenPatricianScene {
    private static final Logger logger = LogManager.getLogger(NewGameScene.class);
    @Autowired
    @Qualifier(value="firstNameLoader")
    private RandomNameLoader firstNameLoader;
    @Autowired
    @Qualifier(value="lastNameLoader")
    private RandomNameLoader lastNameLoader;
    private OpenPatricianSpinner objective;
    private OpenPatricianSlider speed;
    private OpenPatricianSlider difficulty;
    private OpenPatricianSpinner startYear;
    private OpenPatricianSpinner hometown;
    private OpenPatricianSpinner map;
    private OpenPatricianRadioButton femaleRadioButton;
    private OpenPatricianRadioButton maleRadioButton;
    private OpenPatricianWoodenTextInput lastName;
    private OpenPatricianWoodenTextInput name;
    private SceneChangeable sceneChangeable;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="jaxb2XmlModelMarshallerMap")
    private Unmarshaller unmarshaller;
    @Autowired
    private Locale locale;
    @Autowired
    private Date gameDate;
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private GameOptionsService gameOptions;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private MapProviderService mapProviderService;
    @Autowired
    private SceneChangeService sceneChanger;

    public NewGameScene() {
        super((Region)new StackPane());
        this.getRoot().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(this.getStyleSheetFilename()).toExternalForm());
    }

    @PostConstruct
    private void createControls() {
        StackPane root = (StackPane)this.getRoot();
        root.setId("NewGameStackPane");
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        grid.setAlignment(Pos.CENTER);
        Label nameLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.name", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)nameLbl, 0, 0);
        this.name = new OpenPatricianWoodenTextInput("");
        this.name.setText(this.firstNameLoader.getRandomName());
        this.name.setSize(25);
        grid.add((Node)this.name, 1, 0);
        Label lastNameLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.lastName", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)lastNameLbl, 3, 0);
        this.lastName = new OpenPatricianWoodenTextInput("");
        this.lastName.setText(this.lastNameLoader.getRandomName());
        this.lastName.setSize(25);
        grid.add((Node)this.lastName, 4, 0);
        ToggleGroup toggleGroup = new ToggleGroup();
        Label sexLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.sex", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)sexLbl, 0, 1);
        this.maleRadioButton = new OpenPatricianRadioButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.male", new Object[0], this.locale.getCurrentLocal()));
        this.maleRadioButton.setSelected(true);
        this.maleRadioButton.setToggleGroup(toggleGroup);
        this.maleRadioButton.setUnselectedLabel(this.messageSource.getMessage("no", new Object[0], this.locale.getCurrentLocal()));
        this.maleRadioButton.setSelectedLabel(this.messageSource.getMessage("yes", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)this.maleRadioButton, 1, 1);
        GridPane.setHalignment((Node)this.maleRadioButton, (HPos)HPos.LEFT);
        this.femaleRadioButton = new OpenPatricianRadioButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.female", new Object[0], this.locale.getCurrentLocal()));
        this.femaleRadioButton.setSelected(false);
        this.femaleRadioButton.setToggleGroup(toggleGroup);
        this.femaleRadioButton.setUnselectedLabel(this.messageSource.getMessage("no", new Object[0], this.locale.getCurrentLocal()));
        this.femaleRadioButton.setSelectedLabel(this.messageSource.getMessage("yes", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)this.femaleRadioButton, 3, 1);
        GridPane.setHalignment((Node)this.femaleRadioButton, (HPos)HPos.LEFT);
        Label mapLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.map", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)mapLbl, 0, 2);
        this.map = new OpenPatricianSpinner();
        this.map.setMaxWidth(200.0);
        this.map.setOptions(FXCollections.observableArrayList(this.getMapList()));
        this.map.selectedIndexProperty().set(0);
        this.map.selectedIndexProperty().addListener((observable, oldValue, newValue) -> this.hometown.setOptions(FXCollections.observableArrayList(this.getHomeTowns4Map())));
        grid.add((Node)this.map, 1, 2);
        GridPane.setHalignment((Node)this.map, (HPos)HPos.LEFT);
        Label hometownLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.hometown", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)hometownLbl, 3, 2);
        this.hometown = new OpenPatricianSpinner();
        this.hometown.setMaxWidth(200.0);
        this.hometown.setOptions(FXCollections.observableArrayList(this.getHomeTowns4Map()));
        this.hometown.selectedIndexProperty().setValue((Number)0);
        this.map.selectedIndexProperty().addListener((observableValue, number, number2) -> {
            this.hometown.setOptions(FXCollections.observableArrayList(this.getHomeTowns4Map()));
            this.hometown.selectedIndexProperty().set(0);
        });
        grid.add((Node)this.hometown, 4, 2);
        GridPane.setHalignment((Node)this.hometown, (HPos)HPos.LEFT);
        Label startYearLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.startYear", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)startYearLbl, 0, 3);
        this.startYear = new OpenPatricianSpinner();
        this.startYear.setMaxWidth(200.0);
        List<OpenPatricianSpinnerOptionDataModel> startYears = this.getStartYears();
        this.startYear.setOptions(FXCollections.observableArrayList(startYears));
        this.startYear.selectedIndexProperty().set(50);
        grid.add((Node)this.startYear, 1, 3);
        GridPane.setHalignment((Node)this.startYear, (HPos)HPos.LEFT);
        Label difficultyLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.difficulty", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)difficultyLbl, 0, 4);
        this.difficulty = new OpenPatricianSlider(200);
        this.difficulty.getStyleClass().addAll((Object[])new String[]{"defaultTextSize24"});
        this.difficulty.setValues(this.getDificutlyList());
        this.difficulty.selectedIndexProperty().setValue((Number)0);
        grid.add((Node)this.difficulty, 1, 4);
        GridPane.setHalignment((Node)this.difficulty, (HPos)HPos.LEFT);
        Label gameSpeedLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.gameSpeed", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)gameSpeedLbl, 3, 4);
        this.speed = new OpenPatricianSlider(200);
        this.speed.getStyleClass().addAll((Object[])new String[]{"defaultTextSize24"});
        this.speed.setValues(this.gameOptions.getGameSpeedList());
        this.speed.selectedIndexProperty().setValue((Number)1);
        grid.add((Node)this.speed, 4, 4);
        GridPane.setHalignment((Node)this.speed, (HPos)HPos.LEFT);
        Label objectiveLbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)objectiveLbl, 0, 5);
        this.objective = new OpenPatricianSpinner();
        this.objective.setMaxWidth(200.0);
        this.objective.setOptions(FXCollections.observableArrayList(this.getObjectiveList()));
        this.objective.selectedIndexProperty().setValue((Number)0);
        grid.add((Node)this.objective, 1, 5);
        GridPane.setHalignment((Node)this.objective, (HPos)HPos.LEFT);
        OpenPatricianStoneButton button = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.startGame", new Object[0], this.locale.getCurrentLocal()));
        button.setOnAction((EventHandler)new NewGameAction());
        grid.add((Node)button, 1, 6);
        GridPane.setHalignment((Node)button, (HPos)HPos.LEFT);
        root.getChildren().add((Object)grid);
    }

    public void setSceneChangeable(IOpenPatricianApplicationWindow sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }

    private List<OpenPatricianSpinnerOptionDataModel> getMapList() {
        java.util.Map maps = this.mapProviderService.getMaps();
        ArrayList<OpenPatricianSpinnerOptionDataModel> l = new ArrayList<OpenPatricianSpinnerOptionDataModel>();
        for (Map.Entry entry : maps.entrySet()) {
            l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage((String)entry.getKey(), new Object[0], this.locale.getCurrentLocal()), (String)entry.getValue()));
        }
        return l;
    }

    private List<OpenPatricianSpinnerOptionDataModel> getHomeTowns4Map() {
        ArrayList<OpenPatricianSpinnerOptionDataModel> l = new ArrayList<OpenPatricianSpinnerOptionDataModel>();
        String selectedValue = this.map.getSelectedValue();
        try {
            logger.debug("Update home towns for map " + selectedValue);
            Map mapData = (Map)this.unmarshaller.unmarshal(this.getSourceFromFile(selectedValue));
            Map.Cities cities = mapData.getCities();
            for (Map.Cities.City city : cities.getCity()) {
                if (!city.getKontorType().equals(EKontorType.KONTOR.name())) continue;
                String cityName = this.messageSource.getMessage(city.getName(), new Object[0], this.locale.getCurrentLocal());
                l.add(new OpenPatricianSpinnerOptionDataModel(cityName, city.getName()));
            }
        }
        catch (IOException e) {
            logger.error("Could not read city data from the selected map: " + selectedValue);
        }
        return l;
    }

    private Source getSourceFromFile(String fileName) {
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        return new StreamSource(resourceAsStream);
    }

    private List<OpenPatricianSpinnerOptionDataModel> getStartYears() {
        ArrayList<OpenPatricianSpinnerOptionDataModel> l = new ArrayList<OpenPatricianSpinnerOptionDataModel>();
        for (int year = 1400; year >= 1300; --year) {
            String y = String.valueOf(year);
            l.add(new OpenPatricianSpinnerOptionDataModel(y));
        }
        return l;
    }

    private List<String> getDificutlyList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.CHANDLER", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.MERCHANT", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.TRADESMAN", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.COUNCILMAN", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.PATRICIAN", new Object[0], this.locale.getCurrentLocal()));
        return l;
    }

    private List<OpenPatricianSpinnerOptionDataModel> getObjectiveList() {
        ArrayList<OpenPatricianSpinnerOptionDataModel> l = new ArrayList<OpenPatricianSpinnerOptionDataModel>();
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective1", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective2", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective3", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective4", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective5", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective6", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective7", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective8", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective9", new Object[0], this.locale.getCurrentLocal())));
        l.add(new OpenPatricianSpinnerOptionDataModel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.objective10", new Object[0], this.locale.getCurrentLocal())));
        return l;
    }

    private String getStyleSheetFilename() {
        return "newGame.css";
    }

    private class NewGameAction
    implements EventHandler<MouseEvent> {
        private NewGameAction() {
        }

        private boolean validInput() {
            if (NewGameScene.this.name.getText() == null || NewGameScene.this.name.getText().trim().equals("")) {
                logger.warn("Name may not be null");
                return false;
            }
            if (NewGameScene.this.lastName.getText() == null || NewGameScene.this.lastName.getText().trim().equals("")) {
                logger.warn("Last name may not be null");
                return false;
            }
            return true;
        }

        public void handle(MouseEvent mouseEvent) {
            try {
                if (this.validInput()) {
                    NewGame newGameDTO = NewGame.builder().difficulty(Difficulty.fromIndex((int)NewGameScene.this.difficulty.getSelectedIndex())).firstName(NewGameScene.this.name.getText()).lastName(NewGameScene.this.lastName.getText()).hometown(NewGameScene.this.hometown.getSelectedValue()).objective(EObjective.values()[NewGameScene.this.objective.getSelectedIndex()]).speed(EGameSpeed.values()[NewGameScene.this.speed.getSelectedIndex()]).startYear(Integer.parseInt(NewGameScene.this.startYear.getSelectedValue())).male(NewGameScene.this.maleRadioButton.isSelected() && !NewGameScene.this.femaleRadioButton.isSelected()).mapName(NewGameScene.this.map.getSelectedValue()).singleplayer(true).environmentInitialisation(true).build();
                    GameStateChange stateChange = new GameStateChange(EGameStatusChange.NEW_GAME);
                    stateChange.setStateChangeData((IGameStateChangeData)newGameDTO);
                    NewGameScene.this.clientServerEventBus.post((Object)stateChange);
                    while (NewGameScene.this.gameDate.getStartYear() == null) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            logger.warn("Interrupted while waiting for the startyear to be set.");
                        }
                    }
                    double width = NewGameScene.this.getRoot().getWidth();
                    double height = NewGameScene.this.getRoot().getHeight();
                    NewGameScene.this.sceneChanger.changeScene(NewGameScene.this.sceneChangeable, NewGameScene.this.uiFactory.getMainGameScene(width, height));
                }
            }
            catch (RuntimeException e) {
                logger.error("Failed to create new game", (Throwable)e);
            }
        }
    }
}

