/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.service;

import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.event.data.MapUpdateCityAdd;
import ch.sahits.game.openpatrician.javafx.model.OpenPatricianSpinnerOptionDataModel;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.utilities.LocalStorage;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.service.LoadAndSaveService;
import com.google.common.eventbus.AsyncEventBus;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class GameOptionsService {
    private static final String SAVEGAME_FILE_EXTENSTION = ".ops";
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LoadAndSaveService loadAndSave;
    private File savegameDir;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private LocalStorage localStorage;

    @PostConstruct
    private void init() {
        this.savegameDir = this.localStorage.getSavegameDirectory();
    }

    public List<String> getGameSpeedList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.break", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.slow", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.normal", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.NewGameScene.fast", new Object[0], this.locale.getCurrentLocal()));
        return l;
    }

    public List<OpenPatricianSpinnerOptionDataModel> getSavegames() {
        FilenameFilter filter = (dir, name) -> name.endsWith(SAVEGAME_FILE_EXTENSTION);
        String[] savegames = this.savegameDir.list(filter);
        ArrayList<OpenPatricianSpinnerOptionDataModel> l = new ArrayList<OpenPatricianSpinnerOptionDataModel>();
        for (String savegame : savegames) {
            String savegameName = savegame.substring(0, savegame.indexOf(46));
            l.add(new OpenPatricianSpinnerOptionDataModel(savegameName));
        }
        return l;
    }

    public void save(String savegameName) {
        String fileName = this.savegameDir + File.separator + savegameName + SAVEGAME_FILE_EXTENSTION;
        this.loadAndSave.serialize(fileName);
    }

    public void load(String savegameName) {
        this.timerEventBus.post((Object)new PauseGame());
        Thread.yield();
        String fileName = this.savegameDir + File.separator + savegameName + SAVEGAME_FILE_EXTENSTION;
        this.loadAndSave.restore(fileName);
        this.clientServerEventBus.post((Object)new GameStateChange(EGameStatusChange.GAME_LOADED));
        PlayerList players = (PlayerList)this.context.getBean(PlayerList.class);
        for (IPlayer player : players) {
            if (!(player instanceof IHumanPlayer)) continue;
            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)new MapUpdateCityAdd(null, player)));
        }
    }
}

