package ch.sahits.game.openpatrician.display;

import ch.sahits.game.graphic.image.ImageConfiguration;
import ch.sahits.game.graphic.loaders.IImageLoaderComponents;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.openpatrician.display.event.handler.impl.IOpenPatricianDisplayEventHandlerComponents;
import ch.sahits.game.openpatrician.display.event.task.IOpenPatricianDisplayTaskComponents;
import ch.sahits.game.openpatrician.display.model.CityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.javafx.control.CheatMenu;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.javafx.model.IOpenPatricianJAvaFXModelComponents;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.IOpenPatricianJavaFXServiceComponents;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.sound.SoundConfiguration;
import ch.sahits.game.openpatrician.utilities.PausableAsyncEventBus;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.plugin.PluginConfiguration;
import ch.sahits.game.openpatrician.utilities.service.LoadAndSaveService;
import ch.sahits.game.openpatrician.utilities.service.PostLoadOperationProvider;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 29, 2014
 */
@Configuration
@Import({ImageConfiguration.class, SoundConfiguration.class, PluginConfiguration.class})
@ComponentScan(basePackageClasses = {
        UICommonConfiguration.class,
        IImageLoaderComponents.class,
        IOpenPatricianJAvaFXModelComponents.class,
        IOpenPatricianJavaFXServiceComponents.class,
        IOpenPatricianDisplayEventHandlerComponents.class,
        IOpenPatricianDisplayTaskComponents.class,
        ch.sahits.game.openpatrician.javafx.service.IOpenPatricianJavaFXServiceComponents.class,
})
@ClassCategory(EClassCategory.STARTUP)
public class UICommonConfiguration {

    @Bean
    public DecoratedTextFactory decoratedDialogTextFactory() {
        return new DecoratedTextFactory(2* Dialog.FRAME_BORDER, 100, Dialog.WRAPPING_WIDTH);
    }
    @Bean
    public Jaxb2Marshaller jaxb2MarshallerImage() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.graphic.data.image");
        return bean;
    }
    @Bean
    public Jaxb2Marshaller jaxb2MarshallerPolygon() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.graphic.data.polygon");
        return bean;
    }
    @Bean
    public ExecutorService clientThreadPool() {
        return Executors.newSingleThreadExecutor();
    }
    @Bean
    public SubscriptionLoggingExceptionHandler subscriptionExceptionClientHandler() {
        return new SubscriptionLoggingExceptionHandler();
    }

    @Bean
    public PausableAsyncEventBus clientEventBus() {
        return new PausableAsyncEventBus(clientThreadPool(), subscriptionExceptionClientHandler());
    }

    @Bean
    public ReloadableResourceBundleMessageSource resourceReference() {
        ReloadableResourceBundleMessageSource bundle = new ReloadableResourceBundleMessageSource();
        bundle.setBasename("/resources");
        bundle.setFallbackToSystemLocale(false);
        return bundle;
    }
    @Bean
    public UIFactory uiFactory() {
        return new UIFactory();
    }
    @Bean
    public ScheduledExecutorService uiTimer() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(threads/2 + 1);
    }
    @Bean
    @Lazy
    public TextSizingUtility textSizingUtility() {
        return new TextSizingUtility();
    }

    @Bean
    @Scope("prototype")
    public ICityPlayerProxyJFX cityPlayerProxy(ICity city, IHumanPlayer player, IShip ship) {   // FIXME: 6/13/17 this belongs to standalone and client
        return new CityPlayerProxyJFX(city, player, ship);
    }
    @Bean
    @Scope("prototype")
    public CheatMenu cheatMenu(ICheatCommand command, ReadOnlyDoubleProperty parentWidth) {
        return new CheatMenu(command, parentWidth);
    }
}
