package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import javafx.scene.layout.GridPane;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Dialog displaying a table.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 16, 2013
 *
 */
public abstract class TabelViewDialog extends CloseButtonDialog {
	
	protected GridPane grid;
    @Autowired
    private JavaFXUtils fxUtils;



	public TabelViewDialog(Table model) {
		super();
        fxUtils = new JavaFXUtils();
		setModel(model);
	}
	public TabelViewDialog() {
		super();
		getStylesheets().add(this.getClass().getResource("/styles/base.css").toExternalForm());
		getStyleClass().add("dialog");
	}

	protected void setModel(Table model) {
		if (grid != null) {
			getContent().remove(grid);
		}
        grid = fxUtils.createGridPaneFromModel(model);
		grid.getStyleClass().add("tableFont");
        grid.setLayoutX(2 * FRAME_BORDER);
        grid.setLayoutY(100);
		getContent().add(grid);
    }


}
