package ch.sahits.game.openpatrician.display.dialog.guild;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * Dialog for joining the guild.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 19, 2016
 */
@Slf4j
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class JoinGuildDialog extends CloseButtonDialog {

    /** Reference to the city view model */
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;

    public JoinGuildDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.JoinGuildDialog.title",
                new Object[]{}, locale.getCurrentLocal()));

        IHumanPlayer player = city.getPlayer();
        ICity city = this.city.getCity();
        int fee = guildService.getEntryFee(player);
        String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.JoinGuildDialog.text",
                new Object[]{city.getName(), player.getName(), player.getLastName(), fee}, locale.getCurrentLocal());
        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
        VBox box = new VBox(text);

        String s = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.JoinGuildDialog.joinBtn",
                new Object[]{}, locale.getCurrentLocal());
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
        action.getStyleClass().add("actionButton");
        action.setId("joinGuild");
        final int actionButtonX = (WIDTH - 124) / 2;
        action.setLayoutX(actionButtonX);
        action.setLayoutY(CLOSE_BTN_Y_POS - 24);
        action.setOnAction(joinGuild(player, city, fee));

        box.setLayoutX(50);
        box.setLayoutY(CLOSE_BTN_Y_POS - 500);
        getContent().addAll(box, action);
    }

    private EventHandler<MouseEvent> joinGuild(final IHumanPlayer player,final ICity city, final int fee) {
        return mouseEvent -> {
            try {
                ICompany company = player.getCompany();
                company.updateCash(-fee);
                IGuild guild = guildList.findGuild(city).get();
                guild.join(player);
                ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.city, EViewChangeEvent.MAIN_VIEW_GUILD);
                clientEventBus.post(new NoticeBoardUpdate(proxy));
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                log.error("Failed to join the quild", e);
            }
        };
    }
}
