package ch.sahits.game.openpatrician.display.dialog.service;

import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

/**
 * This interfaces defines methods that are accessed by the Transfer actions
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 11, 2011
 *
 */
public interface ITransferableJFX {


	/**
	 * Retrieve the vessel associated.
	 * @return the associated vesssel
     */
	INavigableVessel getVessel();

	/**
	 * Retrieve the city.
	 * @return the associated city
     */
	ICity getCity();

	/**
	 * Retrieve the player.
	 * @return the associated player
     */
	IPlayer getPlayer();
	/**
	 * Retrieve the dialog type of this transfer
	 * @return transfer dialog type
	 */
	EDialogType getDialogType();
	/**
	 * Retrieve the amount that should be transferred.
	 * @param availableAmountCity available amount in the city
	 * @return amount that should be transferred.
	 */
	int getAmount(int availableAmountCity);
	/**
	 * Retreive the amount category that is movable
	 * @return associated amount enumeration
	 */
	ETransferAmount getMovableAmount();

	/**
	 * Retrieve the price calculation service
	 * @return service to calculate the price.
	 */
	ComputablePriceV2 getComputablePrice();

}
