package ch.sahits.game.openpatrician.display.dialog.service.impl;

import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.service.TransferUtil;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Builder;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 25, 2015
 */
@Getter
@Builder
@ClassCategory({EClassCategory.MODEL,EClassCategory.DIALOG})
public class TransferableState implements ITransferableJFX {
    private final INavigableVessel vessel;
    private final ICity city;
    private final IPlayer player;
    private final EDialogType dialogType;
    private final ETransferAmount movableAmount;
    private final static TransferUtil transferUtility = new TransferUtil();
    private final static ComputablePriceV2 computablePrice = new ComputablePriceV2();
    @Override
    public int getAmount(int availableAmountCity) {
        return transferUtility.calculateAvailableAmount(movableAmount, availableAmountCity);
    }

    @Override
    public ComputablePriceV2 getComputablePrice() {
        return computablePrice;
    }
}
