package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.impl.ThieveState;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import static com.google.common.collect.Lists.newArrayList;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 24, 2013
 */
@Slf4j
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernBurglarDialog extends TavernBaseSideRoomPersonDialog {
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;";
    @ListType(IPlayer.class)
    private final List<IPlayer> residentOponents;
    @ObjectPropertyType(IPlayer.class)
    private ObjectProperty<IPlayer> selectedOponent;
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private DecoratedTextFactory textFactory;
    private BooleanBinding disabeAcceptBinding;

    @Autowired
    private ModelTranslations modelTranslator;

    public TavernBurglarDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getThieve());
        residentOponents = newArrayList();
        selectedOponent = new SimpleObjectProperty<>(this, "selectedOpponent", null);
        for (IPlayer player : city.getCity().getResidentPlayers()) {
            if (!player.equals(city.getPlayer())) {
                residentOponents.add(player);
            }
        }
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBurglarDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        VBox box = new VBox();
        box.setLayoutX(2* Dialog.FRAME_BORDER);
        box.setLayoutY(100);

        String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBurglarDialog.dialog1", new Object[]{}, locale.getCurrentLocal());
        DecoratedText line1 = textFactory.createDecoratedText(template, new HashMap<>());

        DecoratedText emptyLine = textFactory.createDecoratedText(" \n", new HashMap<>());
        box.getChildren().addAll(line1, emptyLine);
        final List<DecoratedText> opponents = newArrayList();
        for (IPlayer opponent : residentOponents) {
            String sb = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBurglarDialog.list",
                    new Object[]{modelTranslator.getLocalDisplayName(opponent.getCareerLevel()), modelTranslator.getLocalDisplayName(opponent.getRank()), opponent.getName(), opponent.getLastName(), opponent.getHometown().getName()}, locale.getCurrentLocal());
            DecoratedText text = textFactory.createDecoratedText(sb, new HashMap<>());
            text.setUserData(opponent);
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
            box.getChildren().add(text);
            opponents.add(text);
        }
        for (final DecoratedText opponent : opponents) {
            opponent.setOnMouseReleased(mouseEvent -> {
                selectedOponent.set((IPlayer) opponent.getUserData());
                disableAcceptButton().invalidate();
                resetStyles(opponents);
                opponent.setStyle(SELECTED_STYLE);
            });
        }


        getContent().add(box);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IHumanPlayer player = city.getPlayer();
                ThieveState burglar = (ThieveState) currentPerson.get();
                player.getCompany().updateCash(-burglar.getPrice());
                int probability = rnd.nextInt(3);
                if (probability < 1) {
                    timedTaskListener.add((TimedTask) taskFactory.getDelayedCaughtAction(player, city.getCity()));
                } else {
                    timedTaskListener.add((TimedTask) taskFactory.getBreakInAction(selectedOponent.get()));
                }
                player.updateCrimialDrive(1);
                burglar.leave();
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                log.error("Failed to accept burglar offer", e);
            }
        };
    }

    /**
     * Remove the bold style from all Text elements.
     * @param texts list of text nodes that should have their style reset.
     */
    private void resetStyles(List<DecoratedText> texts) {
        for (DecoratedText text : texts) {
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        if (disabeAcceptBinding == null) {
            disabeAcceptBinding = new BooleanBinding() {
                {
                    super.bind(selectedOponent);
                }

                @Override
                protected boolean computeValue() {
                    return !residentOponents.isEmpty() && selectedOponent.get() == null;
                }
            };
        }
        return disabeAcceptBinding;
    }


}
