package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.javafx.event.WrappedDialogType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * Runnable for handling wrapped dialog types.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 08, 2016
 */
@Prototype
@ClassCategory(EClassCategory.HANDLER)
public class ViewChangeWrappedRunnable implements Runnable{
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    /** Indicate the item that is selected */
    private final WrappedDialogType selected;


    public ViewChangeWrappedRunnable(WrappedDialogType selected) {
        super();
        Preconditions.checkNotNull(selected, "The notice item my not be null");
        this.selected = selected;
    }



    @Override
    public void run() {
        clientEventBus.post(new ViewChangeEvent(MainGameView.class, selected));
    }

}
