package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;

/**
 * Wait for until a defined time for the arrival of a ship in a city.
 * If the time has passed this event listener unregisters itself from the queue.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 20, 2013
 *
 */
public abstract class WaitTimeForShipArrivalInCity extends ShipEntersPortEventListener {

	private final LocalDateTime deadline;
    @Autowired
	private Date date;

	public WaitTimeForShipArrivalInCity(ICity city, INavigableVessel ship, LocalDateTime deadline) {
		super(ship, city);
		this.deadline = deadline;
	}


    /**
     * Base implementation for the ship arival in a city before a deadline is passed.
     * If the event occurs after the deadline this instance is unregistered from the
     * event bus and the destroy method called. Otherwise the super method is triggered.
     * @param event of ship entering port
     */
    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        if (date.getCurrentDate().isAfter(deadline)){
            clientServerEventBus.unregister(this);
            destroy();
        } else {
            super.handleShipEntersPort(event);
        }
    }
	/**
	 * Action that is taken when the time has run out.
	 */
	public void destroy(){
	}

}
