package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageOfferState;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.engine.event.EventService;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.time.LocalDateTime;

/**
 * Timed task for a marriage offer.
 * Created by andi on 25.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class MarriageOfferTimedTask extends TimedTask {
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private StateFactory stateFactory;
    @Autowired
    @XStreamOmitField
    private EventService eventService;

    private IHumanPlayer player;
    private MarriageBrokerAnnouncementState state;
    private LocalDateTime deadLine;

    public MarriageOfferTimedTask(IHumanPlayer player, MarriageBrokerAnnouncementState state, LocalDateTime deadLine) {
        this.player = player;
        this.state = state;
        this.deadLine = deadLine;
        setExecutionTime(deadLine);
    }

    @Override
    public void run() {
        ISpouseData spouse = createSpouse(state);
        MarriageOfferState marriageOffer = MarriageOfferState.builder()
                .date(deadLine)
                .fromFirstName(state.getFromFirstName())
                .fromLastName(state.getFromLastName())
                .location(state.getLocation())
                .player(player)
                .tillDate(deadLine.plusDays(30))
                .spouse(spouse)
                .build();
        eventService.postToHumanPlayer(marriageOffer, player, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.marriageOffer.title");

        clientEventBus.post(marriageOffer);

    }
    @VisibleForTesting
    ISpouseData createSpouse(MarriageBrokerAnnouncementState state) {
        return stateFactory.createSpouse(state, player);
    }

    @Override
    public String toString() {
        return "MarriageOfferTimedTask{" +
                "UUID=" + getUuid() +
                ", execution at " + getExecutionTime() +
                ", player=" + player.getUuid() + " " + player.getName() + " " + player.getLastName() +
                ", state=" + state +
                '}';
    }
}
