package ch.sahits.game.openpatrician.display.gameplay.impl;

import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * Event handler for the city hall scene.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 03, 2015
 */
@Slf4j
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CityHallScenePolygonInitializer extends AbstractMarketPlaceBuildingPolygonInitializer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    public CityHallScenePolygonInitializer() {
        super("images/scene/cityhall");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        try {
            switch (name) {
                case "Floor": {
                    return createBackToMarketPlaceEvent();
                }
                case "Board": {
                    return event -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_CITY_HALL_BOARD);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
                }
                case "Treasury": {
                    return event -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_CITY_HALL_TREASURY);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
                }
                case "Aldermanoffice": {
                    return event -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_CITY_HALL_ALDERMAN);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
                }
                case "Meetingroom": {
                    return event -> {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_CITY_HALL_MEETINGROOM);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    };
                }
                default:
                    throw new IllegalStateException("Unhandled polygon action: " + name);
            }
        } catch (RuntimeException e) {
            log.error("Failed to switch to different scene: "+name, e);
            return null;
        }

    }
}
