package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.graphic.image.EScaleDirection;
import ch.sahits.game.graphic.image.ImageScaleState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.scene.image.ImageView;
/**
 * Place the image view in the center
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 10, 2013
 *
 */
@ClassCategory(EClassCategory.JAVAFX)
public class MainGameImageView extends BaseMainGameImageView {

	public MainGameImageView(double width, double height, ImageView imgView, ImageScaleState state) {
		super();
		setImageView(width, height, imgView, state);
	}
	/**
	 * Set the image view at the right position.
	 * @param width of the parent control
	 * @param height of the parent control
	 * @param imgView ImageView to be added.
	 */
	void setImageView(double width, double height, ImageView imgView, ImageScaleState state) {
		getChildren().clear();
		double x = Math.max((width - imgView.getBoundsInLocal().getWidth())/2,0);
		double y = Math.max((height - imgView.getBoundsInLocal().getHeight())/2,0);
		if (x > 0) {
			state.border();
			state.setBorderDirection(EScaleDirection.HORIZONTAL);
			state.setBordered((int) x);
		} else if (y > 0) {
			state.border();
			state.setBorderDirection(EScaleDirection.VERTICAL);
			state.setBordered((int) y);
		}
		imgView.setLayoutX(x);
		imgView.setLayoutY(y);
		getChildren().add(imgView);
	}

}
