package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.openpatrician.display.SceneChangeable;
import ch.sahits.game.openpatrician.javafx.OpenPatricianScene;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

/**
 * Service class for scene changing.
 * Created by andi on 02.04.17.
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class SceneChangeService {
    /**
     * Change the current scene.
     * @param sceneChangeable delegate on which the scene will be changed
     * @param scene new Scene.
     */
    public void changeScene(SceneChangeable sceneChangeable, OpenPatricianScene scene) {
        double oldWidth = 0;
        double oldHeight = 0;
        double newWidth = sceneChangeable.getSceneWidth();
        double newHeight = sceneChangeable.getSceneHeight();
        sceneChangeable.changeScene(scene);
        // Fix needed to avoid bug https://javafx-jira.kenai.com/browse/RT-30392
        scene.widthChange(oldWidth, newWidth); // old value is wrong as that is the same as the new one
        scene.heightChange(oldHeight, newHeight);
        if (scene instanceof BaseStartupScene) {
            ((BaseStartupScene)scene).setSceneChangeable(sceneChangeable); // propagate
        }
    }
}
