/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CheatKeyEventListener
implements EventHandler<KeyEvent> {
    private static final Logger log = LoggerFactory.getLogger(CheatKeyEventListener.class);
    @Autowired
    @ListType(value=ICheatCommand.class)
    private List<ICheatCommand> cheatCommands;
    @Autowired
    @Qualifier(value="clientEventBus")
    private EventBus clientEventBus;
    private boolean cheatModeActive = false;

    public void handle(KeyEvent event) {
        try {
            Optional<ICheatCommand> commandOpt;
            if (event.getCode().equals((Object)KeyCode.F10)) {
                this.cheatModeActive = !this.cheatModeActive;
                log.debug("Toggle cheatmode. Cheat active: {}", (Object)this.cheatModeActive);
            } else if (this.cheatModeActive && event.isControlDown() && (commandOpt = this.getCheatCommandsActivatedByControl().stream().filter(cheat -> cheat.getKey().equals((Object)event.getCode())).findFirst()).isPresent()) {
                ICheatCommand cheatCommand = commandOpt.get();
                this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)cheatCommand));
            }
        }
        catch (RuntimeException e) {
            log.error("Failed to toggle cheat command: " + event.getCode(), (Throwable)e);
        }
    }

    private List<ICheatCommand> getCheatCommandsActivatedByControl() {
        return this.cheatCommands.stream().filter(command -> command.getControlKey().equals((Object)KeyCode.CONTROL)).collect(Collectors.toList());
    }
}

