/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianHorizontalSelector;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.model.DisplayMessages;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.MessageConfiguration;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class MessageConfigurationDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX proxy;
    @Autowired
    private MessageConfiguration messageConfiguration;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DisplayMessages displayMessages;
    private OpenPatricianHorizontalSelector tradeSelector;
    private OpenPatricianHorizontalSelector personalSelector;
    private OpenPatricianHorizontalSelector officialSelector;

    public MessageConfigurationDialog(ICityPlayerProxyJFX proxy) {
        this.proxy = proxy;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.title", new Object[0], this.locale.getCurrentLocal()));
        SimpleDoubleProperty widthProperty = new SimpleDoubleProperty(458.0);
        VBox vbox = new VBox(10.0);
        vbox.setLayoutY(100.0);
        vbox.setLayoutX(30.0);
        Label lbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.trade", new Object[0], this.locale.getCurrentLocal()));
        lbl.getStyleClass().add((Object)"dialogText");
        lbl.setId("tradeLbl");
        this.tradeSelector = new OpenPatricianHorizontalSelector((ReadOnlyDoubleProperty)widthProperty);
        this.tradeSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain20", new Object[0], this.locale.getCurrentLocal()));
        this.tradeSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain50", new Object[0], this.locale.getCurrentLocal()));
        this.tradeSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain100", new Object[0], this.locale.getCurrentLocal()));
        this.tradeSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retainAll", new Object[0], this.locale.getCurrentLocal()));
        OpenPatricianLargeWaxButton deleteTrade = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.deleteAll", new Object[0], this.locale.getCurrentLocal()));
        deleteTrade.setId("tradeTradeDelete");
        deleteTrade.setOnAction(evt -> this.displayMessages.tradeMessagesProperty().removeIf(msg -> msg.getCategory().equals((Object)EMessageCategory.TRADE)));
        this.tradeSelector.selectedIndexProperty().setValue((Number)this.mapBack(this.messageConfiguration.getRetainedTradeMessages()));
        vbox.getChildren().addAll((Object[])new Node[]{lbl, this.tradeSelector, deleteTrade});
        lbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.personal", new Object[0], this.locale.getCurrentLocal()));
        lbl.getStyleClass().add((Object)"dialogText");
        lbl.setId("personalLbl");
        this.personalSelector = new OpenPatricianHorizontalSelector((ReadOnlyDoubleProperty)widthProperty);
        this.personalSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain20", new Object[0], this.locale.getCurrentLocal()));
        this.personalSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain50", new Object[0], this.locale.getCurrentLocal()));
        this.personalSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain100", new Object[0], this.locale.getCurrentLocal()));
        this.personalSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retainAll", new Object[0], this.locale.getCurrentLocal()));
        OpenPatricianLargeWaxButton personalTrade = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.deleteAll", new Object[0], this.locale.getCurrentLocal()));
        personalTrade.setId("personalTradeDelete");
        personalTrade.setOnAction(evt -> this.displayMessages.personalMessagesProperty().removeIf(msg -> msg.getCategory().equals((Object)EMessageCategory.PERSONAL)));
        this.personalSelector.selectedIndexProperty().setValue((Number)this.mapBack(this.messageConfiguration.getRetainedPersonalMessages()));
        vbox.getChildren().addAll((Object[])new Node[]{lbl, this.personalSelector, personalTrade});
        lbl = new Label(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.official", new Object[0], this.locale.getCurrentLocal()));
        lbl.getStyleClass().add((Object)"dialogText");
        lbl.setId("officialLbl");
        this.officialSelector = new OpenPatricianHorizontalSelector((ReadOnlyDoubleProperty)widthProperty);
        this.officialSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain20", new Object[0], this.locale.getCurrentLocal()));
        this.officialSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain50", new Object[0], this.locale.getCurrentLocal()));
        this.officialSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retain100", new Object[0], this.locale.getCurrentLocal()));
        this.officialSelector.valuesProperty().add((Object)this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.retainAll", new Object[0], this.locale.getCurrentLocal()));
        OpenPatricianLargeWaxButton officialTrade = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog.deleteAll", new Object[0], this.locale.getCurrentLocal()));
        officialTrade.setId("officialTradeDelete");
        personalTrade.setOnAction(evt -> this.displayMessages.officialMessagesProperty().removeIf(msg -> msg.getCategory().equals((Object)EMessageCategory.OFFICIAL)));
        this.officialSelector.selectedIndexProperty().setValue((Number)this.mapBack(this.messageConfiguration.getRetainedOfficialMessages()));
        vbox.getChildren().addAll((Object[])new Node[]{lbl, this.officialSelector, officialTrade});
        this.getContent().add((Object)vbox);
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.messageConfiguration.setRetainedTradeMessages(this.map(this.tradeSelector.getSelectedIndex()));
        this.messageConfiguration.setRetainedPersonalMessages(this.map(this.personalSelector.getSelectedIndex()));
        this.messageConfiguration.setRetainedOfficialMessages(this.map(this.officialSelector.getSelectedIndex()));
        this.displayMessages.ensureMessagePoolSize();
        super.executeOnCloseButtonClicked();
    }

    private int map(int retainedIndex) {
        if (retainedIndex == 0) {
            return 20;
        }
        if (retainedIndex == 1) {
            return 50;
        }
        if (retainedIndex == 2) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    private int mapBack(int retainedAmount) {
        if (retainedAmount <= 20) {
            return 0;
        }
        if (retainedAmount <= 50) {
            return 1;
        }
        if (retainedAmount <= 100) {
            return 2;
        }
        return 3;
    }
}

