/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.TabelViewDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.geometry.HPos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class WeaponInventoryDialog
extends TabelViewDialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private IWeaponStorage weaponStorage;
    protected final ICityPlayerProxyJFX city;

    public WeaponInventoryDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        ITradingOffice office = (ITradingOffice)this.city.getPlayer().findTradingOffice(this.city.getCity()).get();
        this.weaponStorage = office.getWeaponStorage();
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponInventoryDialog.title", new Object[0], this.locale.getCurrentLocal()));
        Table model = this.createModel();
        this.setModel(model);
    }

    private Table createModel() {
        Table model = new Table();
        TableHeader header = new TableHeader(2);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.WeaponsDealerState.noticeboardTitle", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponInventoryDialog.inStock", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.RIGHT);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{100, 200});
        for (EWeapon weapon : EWeapon.values()) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(weapon)));
            row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.weaponStorage.getWeapon((IWeapon)weapon))));
            model.add(row);
        }
        return model;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

