/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.dialog.TabelViewDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.DynamicTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.ECellConstraint;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.PrimaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Arrays;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class WeaponTransferDialog
extends TabelViewDialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private ShipService shipService;
    private final ICityPlayerProxyJFX proxy;
    private IWeaponStorage weaponStorage;
    private ITradingOffice office;

    public WeaponTransferDialog(ICityPlayerProxyJFX proxy) {
        this.proxy = proxy;
    }

    @PostConstruct
    private void initializeDialog() {
        this.office = (ITradingOffice)this.proxy.getPlayer().findTradingOffice(this.proxy.getCity()).get();
        this.weaponStorage = this.office.getWeaponStorage();
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponTransferDialog.title", new Object[0], this.locale.getCurrentLocal()));
        Group subTitle = this.createSubTitle(this.proxy);
        subTitle.setLayoutX(30.0);
        subTitle.setLayoutY(80.0);
        this.getContent().add((Object)subTitle);
        Table model = this.createModel();
        this.setModel(model);
    }

    private Group createSubTitle(ICityPlayerProxyJFX city) {
        final INavigableVessel ship = city.getActiveShip();
        final String shipName = ship.getName();
        StringBinding shipLoad = new StringBinding(){
            {
                super.bind(new Observable[]{ship.getLoadBinding()});
            }

            protected String computeValue() {
                return ship.getLoadBinding().asString().get() + " / " + ship.getLoadableSpace() + " " + shipName;
            }
        };
        Text cityText = new Text();
        cityText.setWrappingWidth(160.0);
        cityText.textProperty().bind((ObservableValue)shipLoad);
        cityText.getStyleClass().add((Object)"dialogText");
        Group g = new Group();
        g.setManaged(false);
        BarrelIconView barrel = new BarrelIconView();
        barrel.setLayoutX(174.0);
        barrel.setLayoutY(-12.0);
        StringBinding storageLoad = new StringBinding(){

            protected String computeValue() {
                return WeaponTransferDialog.this.office.storedAmountBinding().asString().get() + " / " + (WeaponTransferDialog.this.office.capacityProperty().get() - WeaponTransferDialog.this.office.getOccupiedSpace());
            }
        };
        Text shipSpace = new Text();
        shipSpace.textProperty().bind((ObservableValue)storageLoad);
        shipSpace.getStyleClass().add((Object)"dialogText");
        shipSpace.setLayoutX(200.0);
        Text storage = new Text(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal()));
        storage.getStyleClass().add((Object)"dialogText");
        storage.setLayoutX(300.0);
        g.getChildren().addAll((Object[])new Node[]{cityText, barrel, shipSpace, storage});
        return g;
    }

    private Table createModel() {
        IShip ship = (IShip)this.proxy.getActiveShip();
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponTransferDialog.header.weapon", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponTransferDialog.header.ship", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponTransferDialog.header.transfer", new Object[0], this.locale.getCurrentLocal())), ECellConstraint.COLSPAN2);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponTransferDialog.header.storage", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.RIGHT);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(4, HPos.RIGHT);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{130, 60, 72, 72, 70});
        List<EWeapon> weapons = Arrays.asList(EWeapon.HAND_WEAPON, EWeapon.TREBUCHET_SMALL, EWeapon.BALLISTA_SMALL, EWeapon.TREBUCHET_BIG, EWeapon.BALLISTA_BIG, EWeapon.BOMBARD, EWeapon.CANNON);
        for (EWeapon weapon : weapons) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(weapon)));
            DynamicTextTableCell shipAmount = new DynamicTextTableCell();
            IntegerBinding shipAmountBinding = this.shipAmount(weapon, ship);
            shipAmount.valueProperty().bind((ObservableValue)shipAmountBinding.asString());
            row.add((ITableCell)shipAmount);
            BooleanBinding disableToShip = this.disableToShipBinding(ship, weapon);
            OpenPatricianSmallWaxButton toShip = new OpenPatricianSmallWaxButton("<");
            toShip.setId("toShip" + weapon);
            toShip.setOnAction(event -> {
                boolean placed;
                if (!toShip.isDisabled() && (placed = this.shipService.placeWeapon(weapon, ship))) {
                    this.weaponStorage.update((IWeapon)weapon, -1);
                    disableToShip.invalidate();
                }
            });
            if (!EWeapon.HAND_WEAPON.equals((Object)weapon)) {
                toShip.disableProperty().bind((ObservableValue)disableToShip);
            } else {
                toShip.disableProperty().bind((ObservableValue)this.weaponStorage.getWeaponProperty((IWeapon)EWeapon.HAND_WEAPON).lessThan(1));
            }
            row.add((ITableCell)new ControlTableCell((Node)toShip));
            OpenPatricianSmallWaxButton toOffice = new OpenPatricianSmallWaxButton(">");
            toOffice.setId("toOffice" + weapon);
            toOffice.setOnAction(event -> {
                boolean removed;
                if (!toOffice.isDisabled() && (removed = this.shipService.removeWeapon(weapon, ship))) {
                    this.weaponStorage.update((IWeapon)weapon, 1);
                    shipAmountBinding.invalidate();
                }
            });
            toOffice.disableProperty().bind((ObservableValue)shipAmountBinding.lessThan(1));
            row.add((ITableCell)new ControlTableCell((Node)toOffice));
            DynamicTextTableCell officeAmount = new DynamicTextTableCell();
            officeAmount.valueProperty().bind((ObservableValue)this.storageAmount(weapon).asString());
            row.add((ITableCell)officeAmount);
            model.add(row);
        }
        return model;
    }

    private BooleanBinding disableToShipBinding(final IShip ship, final EWeapon weapon) {
        return new BooleanBinding(){

            protected boolean computeValue() {
                block4: {
                    super.bind(new Observable[]{WeaponTransferDialog.this.weaponStorage.getWeaponProperty((IWeapon)weapon)});
                    if (ship.getCapacity() <= 0 || WeaponTransferDialog.this.weaponStorage.getWeapon((IWeapon)weapon) <= 0) break block4;
                    List slots = ship.getWeaponSlots();
                    if (WeaponTransferDialog.this.isLargeWeapon(weapon)) {
                        for (int i = 0; i < slots.size(); ++i) {
                            IWeaponSlot slot = (IWeaponSlot)slots.get(i);
                            if (!(slot instanceof PrimaryLargeWeaponSlot)) continue;
                            SecondaryLargeWeaponSlot secondary = (SecondaryLargeWeaponSlot)slots.get(i + 1);
                            if (slot.getWeapon().isPresent() || secondary.getWeapon().isPresent()) continue;
                            return false;
                        }
                    } else {
                        for (IWeaponSlot slot : slots) {
                            if (slot.getWeapon().isPresent()) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        };
    }

    private boolean isLargeWeapon(EWeapon weapon) {
        return weapon.equals((Object)EWeapon.BALLISTA_BIG) || weapon.equals((Object)EWeapon.BOMBARD) || weapon.equals((Object)EWeapon.TREBUCHET_BIG);
    }

    private IntegerBinding shipAmount(final EWeapon weapon, final IShip ship) {
        return new IntegerBinding(){

            protected int computeValue() {
                return ship.getWeaponAmount((IWeapon)weapon);
            }
        };
    }

    private ReadOnlyIntegerProperty storageAmount(EWeapon weapon) {
        return this.weaponStorage.getWeaponProperty((IWeapon)weapon);
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

