/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.cityhall;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.ECityViolationPunishment;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IBallot;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityWallPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ICustomsViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IElectionResult;
import ch.sahits.game.openpatrician.model.city.cityhall.IHeadTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IMilitiaPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IPirateSupportViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IPlunderTradingOfficesViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ISpecialTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ISpecialTaxViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class MeetingRoomDialog
extends CloseButtonDialog {
    private static final Logger log = LoggerFactory.getLogger(MeetingRoomDialog.class);
    @Autowired
    private ModelStateAccessor cityHallAccessor;
    @Autowired
    private MapService citiesInteractionService;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private DateService dateService;
    @Autowired
    private ModelTranslations modelTranslator;
    private final ICityPlayerProxyJFX city;
    private StyleableObjectProperty<Font> font;

    public MeetingRoomDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.title", new Object[0], this.locale.getCurrentLocal()));
        ICityHall cityHall = this.cityHallAccessor.getCityHall(this.city.getCity());
        boolean meetingToday = this.hasMeetingToday(cityHall);
        if (!meetingToday) {
            VBox content = new VBox();
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.noMeeting", new Object[0], this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            content.setLayoutX(text.getLayoutX());
            content.setLayoutY(text.getLayoutY());
            content.getChildren().add((Object)text);
            LocalDateTime d = cityHall.getElectionDate();
            template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.mayorElectionDate", new Object[]{this.modelTranslator.toDisplayString(d)}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            content.getChildren().add((Object)text);
            if (cityHall.getNextCouncilMeeting().isPresent()) {
                d = (LocalDateTime)cityHall.getNextCouncilMeeting().get();
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.councilMeeting", new Object[]{this.modelTranslator.toDisplayString(d)}, this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                content.getChildren().add((Object)text);
            }
            if (cityHall.getAldermanOffice().isPresent()) {
                d = cityHall.getAldermanElectionDate();
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.aldermanElectionDate", new Object[]{this.modelTranslator.toDisplayString(d)}, this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                content.getChildren().add((Object)text);
                if (cityHall.getHanseaticMeetingDate().isPresent()) {
                    d = (LocalDateTime)cityHall.getHanseaticMeetingDate().get();
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.hanseaticMeeting", new Object[]{this.modelTranslator.toDisplayString(d)}, this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    content.getChildren().add((Object)text);
                }
            }
            this.getContent().add((Object)content);
        } else {
            DecoratedText text;
            String template;
            IElectionResult result;
            List candidates;
            DecoratedText text2;
            String template2;
            VBox content = new VBox();
            LocalDateTime electionDate = cityHall.getElectionDate();
            if (this.dateService.isToday(electionDate)) {
                template2 = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.mayoralElection", new Object[0], this.locale.getCurrentLocal());
                text2 = this.textFactory.createDecoratedText(template2, new HashMap());
                content.setLayoutX(text2.getLayoutX());
                content.setLayoutY(text2.getLayoutY());
                content.getChildren().add((Object)text2);
                candidates = cityHall.getCandidates();
                result = (IElectionResult)cityHall.getElectionResult().get();
                for (ICitizen candidate : candidates) {
                    text2 = this.getCandidateRow(candidate, result);
                    content.getChildren().add((Object)text2);
                }
            }
            if (cityHall.getNextCouncilMeeting().isPresent() && this.dateService.isToday((LocalDateTime)cityHall.getNextCouncilMeeting().get())) {
                Optional petition1 = cityHall.getPetition();
                ICityPetition petition = (ICityPetition)petition1.get();
                if (petition instanceof ICityWallPetition) {
                    template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.citywallEnlargement", new Object[0], this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template, new HashMap());
                    content.setLayoutX(text.getLayoutX());
                    content.setLayoutY(text.getLayoutY());
                    content.getChildren().add((Object)text);
                }
                if (petition instanceof IHeadTaxPetition) {
                    double currentTax = cityHall.getTreasury().getCurrentPropertyTax();
                    double newTax = ((IHeadTaxPetition)petition).getNewTaxValue();
                    String template3 = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.changeHeadTax", new Object[]{currentTax, newTax}, this.locale.getCurrentLocal());
                    DecoratedText text3 = this.textFactory.createDecoratedText(template3, new HashMap());
                    content.setLayoutX(text3.getLayoutX());
                    content.setLayoutY(text3.getLayoutY());
                    content.getChildren().add((Object)text3);
                }
                if (petition instanceof ISpecialTaxPetition) {
                    int value = ((ISpecialTaxPetition)petition).getTaxValue();
                    String template4 = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.specialTax", new Object[]{value}, this.locale.getCurrentLocal());
                    DecoratedText text4 = this.textFactory.createDecoratedText(template4, new HashMap());
                    content.setLayoutX(text4.getLayoutX());
                    content.setLayoutY(text4.getLayoutY());
                    content.getChildren().add((Object)text4);
                }
                if (petition instanceof IMilitiaPetition) {
                    String template5 = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.citymilitiaEnlargement", new Object[0], this.locale.getCurrentLocal());
                    text = this.textFactory.createDecoratedText(template5, new HashMap());
                    content.setLayoutX(text.getLayoutX());
                    content.setLayoutY(text.getLayoutY());
                    content.getChildren().add((Object)text);
                }
                HBox box = new HBox(10.0);
                OpenPatricianSmallWaxButton yes = new OpenPatricianSmallWaxButton(this.messageSource.getMessage("yes", new Object[0], this.locale.getCurrentLocal()));
                yes.getStyleClass().add((Object)"actionButton");
                yes.setOnAction(evt -> {
                    try {
                        ((IBallot)cityHall.getBallotResult().get()).vote(true);
                        this.executeOnCloseButtonClicked();
                    }
                    catch (RuntimeException e) {
                        log.error("Failed to accept meeting", (Throwable)e);
                    }
                });
                OpenPatricianSmallWaxButton no = new OpenPatricianSmallWaxButton(this.messageSource.getMessage("no", new Object[0], this.locale.getCurrentLocal()));
                no.getStyleClass().add((Object)"actionButton");
                no.setOnAction(evt -> {
                    try {
                        ((IBallot)cityHall.getBallotResult().get()).vote(false);
                        this.executeOnCloseButtonClicked();
                    }
                    catch (RuntimeException e) {
                        log.error("Failed to dismiss meeting", (Throwable)e);
                    }
                });
                box.getChildren().addAll((Object[])new Node[]{yes, no});
                content.getChildren().add((Object)box);
            }
            if (cityHall.getAldermanOffice().isPresent()) {
                if (this.dateService.isToday(cityHall.getAldermanElectionDate())) {
                    template2 = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.aldermanElection", new Object[0], this.locale.getCurrentLocal());
                    text2 = this.textFactory.createDecoratedText(template2, new HashMap());
                    content.setLayoutX(text2.getLayoutX());
                    content.setLayoutY(text2.getLayoutY());
                    content.getChildren().add((Object)text2);
                    candidates = cityHall.getAldermanCandidates().getAll();
                    result = (IElectionResult)cityHall.getElectionResult().get();
                    for (ICitizen candidate : candidates) {
                        text2 = this.getCandidateRow(candidate, result);
                        content.getChildren().add((Object)text2);
                    }
                }
                if (cityHall.getHanseaticMeetingDate().isPresent() && this.dateService.isToday((LocalDateTime)cityHall.getHanseaticMeetingDate().get())) {
                    IAldermanOffice office = (IAldermanOffice)cityHall.getAldermanOffice().get();
                    ICityViolation violation = (ICityViolation)office.getViolation().get();
                    if (violation instanceof ICustomsViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.customsViolation", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add((Object)text);
                    }
                    if (violation instanceof IPlunderTradingOfficesViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.plundering", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add((Object)text);
                    }
                    if (violation instanceof IPirateSupportViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.pirateSupport", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add((Object)text);
                    }
                    if (violation instanceof ISpecialTaxViolation) {
                        template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.specialTaxViolation", new Object[]{violation.getCity().getName()}, this.locale.getCurrentLocal());
                        text = this.textFactory.createDecoratedText(template, new HashMap());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add((Object)text);
                    }
                    ECityViolationPunishment punishment = violation.getPunishment();
                    ITreasury otherTreasury = this.cityHallAccessor.getCityHall(violation.getCity()).getTreasury();
                    DecoratedText punishmentText = this.getPunishment(punishment, otherTreasury);
                    content.getChildren().add((Object)punishmentText);
                    String template6 = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog.violationAgreement", new Object[0], this.locale.getCurrentLocal());
                    DecoratedText text5 = this.textFactory.createDecoratedText(template6, new HashMap());
                    content.getChildren().add((Object)text5);
                    HBox box = new HBox(10.0);
                    OpenPatricianSmallWaxButton yes = new OpenPatricianSmallWaxButton(this.messageSource.getMessage("yes", new Object[0], this.locale.getCurrentLocal()));
                    yes.getStyleClass().add((Object)"actionButton");
                    yes.setId("yes");
                    yes.setOnAction(evt -> {
                        try {
                            ((IBallot)cityHall.getBallotResult().get()).vote(true);
                            this.executeOnCloseButtonClicked();
                        }
                        catch (RuntimeException e) {
                            log.error("Failed to accept meeting", (Throwable)e);
                        }
                    });
                    OpenPatricianSmallWaxButton no = new OpenPatricianSmallWaxButton(this.messageSource.getMessage("no", new Object[0], this.locale.getCurrentLocal()));
                    no.getStyleClass().add((Object)"actionButton");
                    no.setId("no");
                    no.setOnAction(evt -> {
                        try {
                            ((IBallot)cityHall.getBallotResult().get()).vote(false);
                            this.executeOnCloseButtonClicked();
                        }
                        catch (RuntimeException e) {
                            log.error("Failed to dismiss meeting", (Throwable)e);
                        }
                    });
                    box.getChildren().addAll((Object[])new Node[]{yes, no});
                    content.getChildren().add((Object)box);
                }
            }
            this.getContent().add((Object)content);
        }
    }

    private DecoratedText getPunishment(ECityViolationPunishment punishment, ITreasury otherTreasury) {
        switch (punishment) {
            case SMALL_FINE: {
                int fine = this.citiesInteractionService.getFine(punishment, otherTreasury);
                String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.smallFine", new Object[]{fine}, this.locale.getCurrentLocal());
                return this.textFactory.createDecoratedText(template, new HashMap());
            }
            case MEDIUM_FINE: {
                int fine = this.citiesInteractionService.getFine(punishment, otherTreasury);
                String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.mediumFine", new Object[]{fine}, this.locale.getCurrentLocal());
                return this.textFactory.createDecoratedText(template, new HashMap());
            }
            case LARGE_FINE: {
                int fine = this.citiesInteractionService.getFine(punishment, otherTreasury);
                String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.largeFine", new Object[]{fine}, this.locale.getCurrentLocal());
                return this.textFactory.createDecoratedText(template, new HashMap());
            }
            case BLOCKADE: {
                String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog.boycott", new Object[0], this.locale.getCurrentLocal());
                return this.textFactory.createDecoratedText(template, new HashMap());
            }
        }
        return null;
    }

    private DecoratedText getCandidateRow(ICitizen candidate, IElectionResult result) {
        Object[] args;
        if (candidate instanceof IHumanPlayer) {
            IPlayer p = (IPlayer)candidate;
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(p.getPersonalData().isMale(), true), this.modelTranslator.getLocalDisplayName(p.getCareerLevel()), this.modelTranslator.getLocalDisplayName(p.getRank()), p.getName() + " " + p.getLastName()};
        } else {
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(true, true), this.modelTranslator.getLocalDisplayName((ICareer)EEconomicCareer.SMART), this.modelTranslator.getLocalDisplayName(candidate.getRank()), candidate.getName() + " " + candidate.getLastName()};
        }
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoNotice.candidate", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setOnMouseReleased(evt -> {
            result.vote(candidate);
            this.executeOnCloseButtonClicked();
        });
        return text;
    }

    private boolean hasMeetingToday(ICityHall cityHall) {
        return cityHall.getElectionResult().isPresent() || cityHall.getBallotResult().isPresent();
    }

    @Override
    public void executeOnCloseButtonClicked() {
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MeetingRoomDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<MeetingRoomDialog, Font> FONT = new CssMetaData<MeetingRoomDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(MeetingRoomDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(MeetingRoomDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

