/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageFeastRequestState;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class MarriageFeastRequestDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private DateService dateService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private ClientViewState clientViewState;
    private final MarriageFeastRequestState state;

    public MarriageFeastRequestDialog(MarriageFeastRequestState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String date = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation().getName(), date});
        this.addVerticalSpacer(20);
        if (this.state.isGenderMale()) {
            this.addDecoratedText("letter.salutation.male", "salutationMale", this.state.getToLastName());
        } else {
            this.addDecoratedText("letter.salutation.female", "salutationFemale", this.state.getToLastName());
        }
        this.addVerticalSpacer(20);
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.events.MarriageFeastRequestDialog.content", "content", new Object[0]);
        LocalDateTime decisionDeadline = this.state.getDate().plusMonths(1L);
        if (!this.dateService.isPast(decisionDeadline)) {
            OpenPatricianLargeWaxButton button = this.addActionButton("ch.sahits.game.openpatrician.display.dialog.events.MarriageFeastRequestDialog.accept", "acceptBtn");
            button.setId("acceptBtn");
            if (this.state.isAccepted()) {
                button.setDisable(true);
            } else {
                button.setOnAction(event -> {
                    this.taskList.add((TimedTask)this.taskFactory.getMarriageFeastDelivery(decisionDeadline, (IPlayer)this.clientViewState.getPlayer(), this.state.getLocation()));
                    this.state.setAccepted(true);
                    this.executeOnCloseButtonClicked();
                });
            }
        }
    }
}

