/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageOfferState;
import ch.sahits.game.openpatrician.clientserverinterface.model.task.MarriageTask;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.engine.event.EventEngineState;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import java.time.LocalDateTime;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class MarriageOfferDialog
extends DefaultSimpleDialog {
    private static final Logger log = LoggerFactory.getLogger(MarriageOfferDialog.class);
    private final MarriageOfferState state;
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imgLoader;
    @Autowired
    private Date date;
    @Autowired
    private DateService dateService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private EventEngineState eventState;

    public MarriageOfferDialog(MarriageOfferState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = this.modelTranslations.toDisplayString(this.state.getDate());
        String tillDate = this.modelTranslations.toDisplayString(this.state.getTillDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), letterDate});
        this.addVerticalSpacer(20);
        if (this.state.getPlayer().getPersonalData().isMale()) {
            this.addDecoratedText("letter.salutation.male", "salutationMale", this.state.getPlayer().getLastName());
        } else {
            this.addDecoratedText("letter.salutation.female", "salutationFemale", this.state.getPlayer().getLastName());
        }
        this.addVerticalSpacer(20);
        if (this.state.getPlayer().getPersonalData().isMale()) {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.MarriageOfferDialog.content.male", "contentMale", this.state.getSpouse().getName(), this.state.getSpouse().getLastName(), this.state.getSpouse().getBirthPlace().getName());
        } else {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.MarriageOfferDialog.content.female", "contentFemale", this.state.getSpouse().getName(), this.state.getSpouse().getLastName(), this.state.getSpouse().getBirthPlace().getName());
        }
        BorderPane centered = new BorderPane();
        centered.setPrefWidth(458.0);
        Pane pane = new Pane();
        centered.setCenter((Node)pane);
        Image img = this.imgLoader.getImage("images/portraitBackground");
        ImageView background = new ImageView(img);
        background.setFitWidth(200.0);
        background.setPreserveRatio(true);
        String portraitResouce = this.state.getSpouse().getPortraitResourceName();
        ImageView portrait = new ImageView(this.imgLoader.loadImage(portraitResouce));
        portrait.setFitWidth(200.0);
        portrait.setPreserveRatio(true);
        img = this.imgLoader.getImage("images/retro-gold-frame-oval");
        ImageView frame = new ImageView(img);
        frame.setFitWidth(200.0);
        frame.setPreserveRatio(true);
        pane.getChildren().addAll((Object[])new Node[]{background, portrait, frame});
        PlaceHolder ph = new PlaceHolder(129.0, 1.0);
        centered.setLeft((Node)ph);
        this.addNode((Node)centered, "portrait");
        this.addDecoratedText("letter.feedback.date", "deadline", Pos.CENTER, new Object[]{tillDate});
        this.addVerticalSpacer(20);
        this.addDecoratedText("letter.greetings", "grettings", Pos.CENTER, new Object[0]);
        this.addDecoratedText("letter.fullname", "signature", Pos.CENTER_RIGHT, new Object[]{this.state.getFromFirstName(), this.state.getFromLastName()});
        if (!this.dateService.isPast(this.state.getTillDate())) {
            OpenPatricianLargeWaxButton button = this.addActionButton("accept.offer", "acceptBtn");
            if (this.state.isAccepted()) {
                button.setDisable(true);
            } else {
                button.setOnAction(this.createAcceptOffer());
            }
        }
    }

    private EventHandler<MouseEvent> createAcceptOffer() {
        return mouseEvent -> {
            try {
                LocalDateTime weddingDate = this.date.getCurrentDate().plusDays(21L);
                MarriageAnnouncementState announcementState = MarriageAnnouncementState.builder().date(this.date.getCurrentDate()).player(this.state.getPlayer()).spouse(this.state.getSpouse()).weddingDate(weddingDate).build();
                DisplayStateMessage message = new DisplayStateMessage(EMessageCategory.PERSONAL, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.marriage.title", (IDialogState)announcementState, new Object[0]);
                this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.state.getPlayer(), (Object)message));
                this.clientEventBus.post((Object)announcementState);
                MarriageTask task = this.taskFactory.getMarriageCelebrationEvent(weddingDate, this.state.getPlayer(), this.state.getPlayer().getHometown(), this.state.getSpouse());
                this.taskList.add((TimedTask)task);
                this.state.setAccepted(true);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to order marriage celebrations", (Throwable)e);
            }
        };
    }
}

