/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.loaner;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.model.city.impl.Debt;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerGiveLoanDialog
extends DefaultSimpleDialog {
    private static final Logger log = LoggerFactory.getLogger(LoanerGiveLoanDialog.class);
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private LoanerService loanerService;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=ILoanRequest.class)
    private ObjectProperty<ILoanRequest> selectedRequest = new SimpleObjectProperty(null);
    @ListType(value=Node.class)
    private List<Node> loans = new ArrayList<Node>();
    private OpenPatricianLargeWaxButton acceptBtn;
    private DecoratedText loanAgreement;
    @ListType(value=Double.class)
    private List<Double> interestLevels;
    private IntegerProperty selectedInterestLevel;

    public LoanerGiveLoanDialog(ICityPlayerProxyJFX city) {
        super(5);
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.loaner = (LoanerState)this.loanerService.findLoaner(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.giveLoan", new Object[0], this.locale.getCurrentLocal()));
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.subHeader", "intro", new Object[0]);
        this.addVerticalSpacer(20);
        int index = 0;
        for (ILoanRequest request : this.loaner.getRequests()) {
            if (index >= 4) continue;
            ICitizen citizen = request.getCitizen();
            String rank = this.translator.getLocalDisplayName(citizen.getRank());
            DecoratedText entry = this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.request", "request" + index, rank, citizen.getName(), citizen.getLastName(), request.getSum(), request.getDurationInWeeks());
            this.loans.add((Node)entry);
            entry.setOnMouseReleased(mouseEvent -> {
                this.selectedRequest.setValue((Object)request);
                this.deactivateAll();
                entry.applyStyle(SELECTED_STYLE);
            });
            entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
            ++index;
        }
        this.acceptBtn = this.addActionButton("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.btnLabel", "giveLoanBtn");
        this.acceptBtn.setDisable(true);
        this.selectedRequest.addListener((observableValue, oldRequest, newRequest) -> {
            if (newRequest != null) {
                this.acceptBtn.setDisable(false);
            }
        });
        this.acceptBtn.setOnAction(this.createAcceptHandlerPage1());
    }

    private void deactivateAll() {
        for (Node node : this.loans) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private EventHandler<MouseEvent> createAcceptHandlerPage1() {
        return mouseEvent -> {
            try {
                this.clearContent();
                this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.subHeader2", "introText", new Object[0]);
                StackPane interestSelectionPane = new StackPane();
                Image minus = this.imageLoader.getImage("icons/minusIcon");
                Image plus = this.imageLoader.getImage("icons/plusIcon");
                Label reduceInterestLbl = new Label("", (Node)new ImageView(minus));
                Label increaseInterestLbl = new Label("", (Node)new ImageView(plus));
                this.interestLevels = new ArrayList<Double>();
                this.interestLevels.add(0.011);
                this.interestLevels.add(0.013);
                this.interestLevels.add(0.016);
                this.interestLevels.add(0.019);
                this.interestLevels.add(0.025);
                this.selectedInterestLevel = new SimpleIntegerProperty(2);
                Text interstLbl = new Text();
                interstLbl.getStyleClass().add((Object)"dialogText");
                interstLbl.setText(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.interestLevel2", new Object[0], this.locale.getCurrentLocal()));
                BorderPane interestPane = new BorderPane();
                interestPane.setLeft((Node)reduceInterestLbl);
                interestPane.setRight((Node)increaseInterestLbl);
                interestPane.setCenter((Node)interstLbl);
                interestSelectionPane.getChildren().add((Object)interestPane);
                this.addNode((Node)interestSelectionPane, "interest");
                this.loanAgreement = this.createLoanAggreement(this.interestLevels, this.selectedInterestLevel);
                reduceInterestLbl.setOnMouseReleased(mouseEvent1 -> {
                    int selectedIndex = this.selectedInterestLevel.get();
                    if (selectedIndex > 0) {
                        this.selectedInterestLevel.setValue((Number)(selectedIndex - 1));
                        this.remove((Node)this.loanAgreement);
                        this.loanAgreement = this.createLoanAggreement(this.interestLevels, this.selectedInterestLevel);
                        interstLbl.setText(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.interestLevel" + this.selectedInterestLevel.get(), new Object[0], this.locale.getCurrentLocal()));
                    }
                });
                increaseInterestLbl.setOnMouseReleased(mouseEvent1 -> {
                    int selectedIndex = this.selectedInterestLevel.get();
                    if (selectedIndex < this.interestLevels.size() - 1) {
                        this.selectedInterestLevel.setValue((Number)(selectedIndex + 1));
                        this.remove((Node)this.loanAgreement);
                        this.loanAgreement = this.createLoanAggreement(this.interestLevels, this.selectedInterestLevel);
                        interstLbl.setText(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.interestLevel" + this.selectedInterestLevel.get(), new Object[0], this.locale.getCurrentLocal()));
                    }
                });
                this.acceptBtn = this.addActionButton("ch.sahits.game.openpatrician.display.dialog.TavernBaseSideRoomPersonDialog.accept", "acceptBtn");
                this.acceptBtn.setOnAction(this.createAcceptHandlerPage2());
            }
            catch (RuntimeException e) {
                log.error("Failed to display details", (Throwable)e);
            }
        };
    }

    private DecoratedText createLoanAggreement(List<Double> interestLevels, IntegerProperty selectedInterestLevel) {
        double interestSmall = interestLevels.get(selectedInterestLevel.get());
        String interest = String.format("%.1f", interestSmall * 100.0);
        int sum = ((ILoanRequest)this.selectedRequest.get()).getSum();
        int paybacksum = (int)((1.0 + interestSmall) * (double)sum);
        return this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerGiveLoanDialog.loanAgreement", "loanAgreement", sum, ((ILoanRequest)this.selectedRequest.get()).getDurationInWeeks(), interest, paybacksum);
    }

    private EventHandler<MouseEvent> createAcceptHandlerPage2() {
        return mouseEvent -> {
            try {
                ILoanRequest request = (ILoanRequest)this.selectedRequest.get();
                double interest = this.interestLevels.get(this.selectedInterestLevel.get()) + 1.0;
                LocalDateTime now = this.date.getCurrentDate();
                IHumanPlayer player = this.city.getPlayer();
                Debt debt = Debt.builder().debitor(request.getCitizen()).creditor((ICreditor)player).interest(interest).dueDate(now.plusWeeks(request.getDurationInWeeks())).amount(request.getSum()).loanTakeOut(now).build();
                this.loaner.addDebt((IDebt)debt);
                this.loaner.getRequests().remove(request);
                IReputation reputation = this.city.getCity().getReputation((IPlayer)player);
                player.getCompany().updateCash((long)(-request.getSum()));
                reputation.update(request.getSum() / 1000 * 10);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to give loadn", (Throwable)e);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

