/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.loaner;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerPaybackDialog
extends DefaultSimpleDialog {
    private static final Logger log = LoggerFactory.getLogger(LoanerPaybackDialog.class);
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private LoanerService loanerService;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=IDebt.class)
    private ObjectProperty<IDebt> selectedDebt = new SimpleObjectProperty(null);
    @ListType(value=Node.class)
    private List<Node> loans = new ArrayList<Node>();

    public LoanerPaybackDialog(ICityPlayerProxyJFX city) {
        super(false);
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        ICity city1 = this.city.getCity();
        this.loaner = (LoanerState)this.loanerService.findLoaner(city1);
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.notice.NoticeBoardFactory.repayLoan", new Object[0], this.locale.getCurrentLocal()));
        this.addVerticalSpacer(20);
        List debts = this.loanerService.findDebts((ILoaner)this.loaner, (IPlayer)this.city.getPlayer());
        if (debts.isEmpty()) {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerPaybackDialog.debtFree", "debtFree", new Object[0]);
        } else {
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerPaybackDialog.subHeader", "introText", new Object[0]);
            for (IDebt debt : debts) {
                int payback = this.loanerService.calculatePaybacksum(debt);
                String cityName = city1.getName();
                LocalDateTime dueDate1 = debt.getDueDate();
                String dueDate = this.modelTranslations.toDisplayString(dueDate1);
                DecoratedText entry = this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerPaybackDialog.payback", "payback", payback, cityName, dueDate);
                entry.setOnMouseReleased(mouseEvent -> {
                    this.selectedDebt.setValue((Object)debt);
                    this.deactivateAll();
                    entry.applyStyle(SELECTED_STYLE);
                });
                entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
                this.loans.add((Node)entry);
            }
            OpenPatricianLargeWaxButton acceptBtn = this.addActionButton("ch.sahits.game.openpatrician.display.dialog.LoanerPaybackDialog.paybackBtn", "paybackBtn");
            acceptBtn.setDisable(true);
            this.selectedDebt.addListener((observableValue, oldDebt, newDebt) -> {
                if (newDebt != null) {
                    acceptBtn.setDisable(false);
                }
            });
            acceptBtn.setOnAction(this.createAcceptHandler());
        }
    }

    private void deactivateAll() {
        for (Node node : this.loans) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                ICompany company = this.city.getPlayer().getCompany();
                long cash = company.getCash();
                IDebt debt = (IDebt)this.selectedDebt.get();
                int debtTotal = this.loanerService.calculatePaybacksum(debt);
                if (cash < (long)debtTotal) {
                    this.clearContent();
                    this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerPaybackDialog.noRepay", "noRepay", new Object[0]);
                } else {
                    debt.getCreditor().receiveSum((long)debtTotal);
                    company.updateCash((long)(-debtTotal));
                    this.loaner.getDebts().remove(debt);
                    this.executeOnCloseButtonClicked();
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to pay back loan", (Throwable)e);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

