/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.sea;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ConvoyService;
import ch.sahits.game.openpatrician.clientserverinterface.service.OutriggerService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.ConvoyList;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ConvoyDialog
extends CloseButtonDialog {
    private static final Logger log = LoggerFactory.getLogger(ConvoyDialog.class);
    private final ICityPlayerProxyJFX city;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    private OutriggerService outriggerService;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ShipService shipService;
    @Autowired
    private ConvoyList convoyList;
    @Autowired
    private ConvoyService convoyService;

    public ConvoyDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        INavigableVessel vessel = this.viewState.getCurrentCityProxy().get().getActiveShip();
        if (vessel instanceof IShip) {
            this.initializeCreateConvoyDialog((IShip)vessel);
        } else {
            this.initializeDissolveConvoyDialog((IConvoy)vessel);
        }
    }

    private void initializeCreateConvoyDialog(IShip vessel) {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.createTitle", new Object[0], this.locale.getCurrentLocal()));
        if (this.shipService.isOrlegCapable(vessel, this.viewState.getCurrentCityProxy().get().getCity())) {
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.fullfilledRequirements.part1", new Object[]{vessel.getName()}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            VBox box = new VBox(new Node[]{text});
            HBox hbox = new HBox(50.0);
            String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.createPrivateConvoy", new Object[0], this.locale.getCurrentLocal());
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
            action.getStyleClass().add((Object)"actionButton");
            action.setId("privateConvoy");
            action.setOnAction(this.createPrivateConvoy(vessel));
            hbox.getChildren().add((Object)action);
            s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.createPublicConvoy", new Object[0], this.locale.getCurrentLocal());
            action = new OpenPatricianLargeWaxButton(s);
            action.getStyleClass().add((Object)"actionButton");
            action.setId("publicConvoy");
            action.setOnAction(this.createPublicConvoy(vessel));
            hbox.getChildren().add((Object)action);
            box.getChildren().add((Object)hbox);
            List presentConvoys = this.convoyList.findConvoy(this.city.getCity());
            if (presentConvoys.isEmpty()) {
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.fullfilledRequirements.part2", new Object[]{vessel.getName()}, this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                box.getChildren().add((Object)text);
            } else {
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.fullfilledRequirements.part2_2", new Object[]{vessel.getName()}, this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                box.getChildren().add((Object)text);
                this.addConvoyList(box, presentConvoys, vessel);
            }
            box.setLayoutX(50.0);
            box.setLayoutY(127.0);
            this.getContent().addAll((Object[])new Node[]{box});
        } else {
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.unfullfilledRequirements", new Object[]{vessel.getName()}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            VBox box = new VBox(new Node[]{text});
            GridPane pane1 = new GridPane();
            pane1.setLayoutX(30.0);
            pane1.setLayoutY(200.0);
            pane1.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(100.0), new ColumnConstraints(50.0), new ColumnConstraints(50.0), new ColumnConstraints(50.0)});
            Image sailorIcon = this.imageLoader.getImage("icons/64/sailor-icon", 32.0, 32.0);
            Text captain = new Text(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.captain", new Object[0], this.locale.getCurrentLocal()));
            captain.getStyleClass().add((Object)"dialogText");
            pane1.add((Node)captain, 0, 0);
            int amountSailors = this.getAmountSailors();
            Text sailors = new Text(String.valueOf(amountSailors));
            sailors.getStyleClass().add((Object)"dialogText");
            HBox hbox = new HBox(new Node[]{sailors, new ImageView(sailorIcon)});
            pane1.add((Node)hbox, 1, 0);
            int minStrength = this.outriggerService.getRequiredWeaponStrength(this.city.getCity());
            template = this.messageSource.getMessage("ch.sahits.game.openpatrician.model.ship.impl.Ship.weaponStrengthEven", new Object[]{minStrength}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            pane1.add((Node)text, 2, 0);
            box.getChildren().add((Object)pane1);
            List presentConvoys = this.convoyList.findConvoy(this.city.getCity());
            if (!presentConvoys.isEmpty()) {
                template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.joinConvoy", new Object[]{vessel.getName()}, this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                box.getChildren().add((Object)text);
                this.addConvoyList(box, presentConvoys, vessel);
            }
            box.setLayoutX(50.0);
            box.setLayoutY(127.0);
            this.getContent().addAll((Object[])new Node[]{box});
        }
    }

    private void addConvoyList(VBox box, List<IConvoy> presentConvoys, IShip ship) {
        VBox innerBox = new VBox();
        int i = 0;
        for (IConvoy convoy : presentConvoys) {
            String key = "ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.ship";
            String loadedText = this.messageSource.getMessage("ch.sahits.game.javafx.service.NoticeBoardShipSelectionMenuProvider.ship", new Object[]{convoy.getName(), convoy.getCapacity()}, this.locale.getCurrentLocal());
            DecoratedText dt = this.textFactory.createDecoratedText(loadedText, new HashMap());
            dt.setId("convoy" + i);
            innerBox.getChildren().add((Object)dt);
            dt.setOnMouseReleased(evt -> {
                this.convoyService.join(convoy, ship);
                this.executeOnCloseButtonClicked();
            });
            ++i;
        }
        innerBox.setLayoutX(50.0);
        box.getChildren().add((Object)innerBox);
    }

    private EventHandler<MouseEvent> createPublicConvoy(IShip vessel) {
        return event -> {
            try {
                this.convoyService.create(vessel, true);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to create public convoy", (Throwable)e);
            }
        };
    }

    private EventHandler<MouseEvent> createPrivateConvoy(IShip vessel) {
        return event -> {
            try {
                this.convoyService.create(vessel, false);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to create private convoy", (Throwable)e);
            }
        };
    }

    private void initializeDissolveConvoyDialog(IConvoy vessel) {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.dissolveTitle", new Object[0], this.locale.getCurrentLocal()));
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.areYouSure", new Object[]{vessel.getName()}, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        VBox box = new VBox(new Node[]{text});
        int actionButtonX = 197;
        String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.dissolve", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
        action.getStyleClass().add((Object)"actionButton");
        action.setId("dissolve");
        ICity city = this.viewState.getCurrentCityProxy().get().getCity();
        action.setOnAction(this.dissolve(vessel, city));
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        box.setLayoutX(50.0);
        box.setLayoutY(127.0);
        this.getContent().addAll((Object[])new Node[]{box, action});
    }

    private EventHandler<MouseEvent> dissolve(IConvoy vessel, ICity city) {
        return event -> {
            try {
                List ships = this.convoyService.dissolve(vessel, city);
                ships.parallelStream().forEach(ship -> this.clientServerEventBus.post((Object)new ShipEntersPortEvent((INavigableVessel)ship, city)));
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to dissolve convoy", (Throwable)e);
            }
        };
    }

    private int getAmountSailors() {
        return 20;
    }
}

