/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.service;

import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.data.xmlmodel.weapon.BasicOffset;
import ch.sahits.game.openpatrician.data.xmlmodel.weapon.BasicSlot;
import ch.sahits.game.openpatrician.data.xmlmodel.weapon.WeaponLocations;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.JavaFXUtils;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.EShipTravelState;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.ESide;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.oxm.Unmarshaller;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DialogUtil {
    private static final Logger log = LoggerFactory.getLogger(DialogUtil.class);
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    private ShipService shipService;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations translations;
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    @Qualifier(value="jaxb2XmlModelMarshallerWeapon")
    private Unmarshaller unmarshaller;
    private WeaponLocations weaponLocations;
    private Image anchor;
    private Image sail;
    private Image repair;

    @PostConstruct
    private void initialize() {
        this.anchor = this.imageLoader.getImage("icons/32/anchor");
        this.sail = this.imageLoader.getImage("icons/32/sailing-icon");
        this.repair = this.imageLoader.getImage("icons/32/repair-icon");
        try {
            Source sourceFromFile = this.getSourceFromFile("/weaponLocation.xml");
            this.weaponLocations = (WeaponLocations)this.unmarshaller.unmarshal(sourceFromFile);
        }
        catch (IOException e) {
            log.warn("Failed to initialize weapons location");
        }
    }

    private Source getSourceFromFile(String fileName) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(fileName);
        return new StreamSource(resourceAsStream);
    }

    public BooleanBinding enableShipCatalogueForShips(final ObservableList<IShip> ships) {
        return new BooleanBinding(){
            {
                super.bind(new Observable[]{ships});
            }

            protected boolean computeValue() {
                return ships.size() > 1;
            }
        };
    }

    public EventHandler<MouseEvent> createNextActionForShips(ObservableList<IShip> ships, ObjectProperty<IShip> currentShip) {
        return mouseEvent -> {
            block4: {
                try {
                    if (ships.size() <= 1) break block4;
                    if (((IShip)ships.get(ships.size() - 1)).equals(currentShip.get())) {
                        currentShip.set((Object)((IShip)ships.get(0)));
                        break block4;
                    }
                    for (int i = 0; i < ships.size() - 1; ++i) {
                        if (!((IShip)ships.get(i)).equals(currentShip.get())) continue;
                        IShip nextShip = (IShip)ships.get(i + 1);
                        currentShip.set((Object)nextShip);
                        break;
                    }
                }
                catch (RuntimeException e) {
                    log.error("Failed to switch to next ship", (Throwable)e);
                }
            }
        };
    }

    public EventHandler<MouseEvent> createPreviousActionForShips(ObservableList<IShip> ships, ObjectProperty<IShip> currentShip) {
        return mouseEvent -> {
            block4: {
                try {
                    if (ships.size() <= 1) break block4;
                    if (((IShip)ships.get(0)).equals(currentShip.get())) {
                        currentShip.set((Object)((IShip)ships.get(ships.size() - 1)));
                        break block4;
                    }
                    for (int i = 1; i < ships.size(); ++i) {
                        if (!((IShip)ships.get(i)).equals(currentShip.get())) continue;
                        IShip prevShip = (IShip)ships.get(i - 1);
                        currentShip.set((Object)prevShip);
                        break;
                    }
                }
                catch (RuntimeException e) {
                    log.error("Failed to switch to previous ship", (Throwable)e);
                }
            }
        };
    }

    public GridPane createGridPaneFromModel(Table model) {
        return this.fxUtils.createGridPaneFromModel(model);
    }

    public GridPane createShipSelection3LinesForShips(ObservableList<IShip> ships, final ObjectProperty<IShip> currentShip) {
        Image weaponIcon = this.imageLoader.getImage("icons/32/bombard-icon");
        Image healthIcon = this.imageLoader.getImage("icons/32/health-icon");
        Image sailorIcon = this.imageLoader.getImage("icons/32/sailor-icon");
        currentShip.setValue((Object)((IShip)ships.get(0)));
        GridPane shipSelectionPane = new GridPane();
        RowConstraints rowConstraint = new RowConstraints(24.0);
        shipSelectionPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraint, rowConstraint, rowConstraint});
        ColumnConstraints colConstraint = new ColumnConstraints(64.0);
        shipSelectionPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colConstraint, colConstraint, colConstraint, colConstraint, colConstraint});
        Text shipName = new Text();
        StringBinding shipNameBinding = new StringBinding(){
            {
                super.bind(new Observable[]{currentShip});
            }

            protected String computeValue() {
                IShip ship = (IShip)currentShip.get();
                return DialogUtil.this.translations.getLocalDisplayName(ship.getShipType()) + " " + ship.getName();
            }
        };
        shipName.getStyleClass().add((Object)"dialogText");
        shipName.setId("shipTypeName");
        shipName.textProperty().bind((ObservableValue)shipNameBinding);
        shipSelectionPane.add((Node)shipName, 0, 0, 5, 1);
        GridPane.setHalignment((Node)shipName, (HPos)HPos.CENTER);
        BooleanBinding enablePrevNext = this.enableShipCatalogueForShips(ships);
        final OpenPatricianSmallWaxButton prevShip = new OpenPatricianSmallWaxButton("<");
        prevShip.setId("prevShip");
        prevShip.getStyleClass().add((Object)"actionButton");
        prevShip.setOnAction(this.createPreviousActionForShips(ships, currentShip));
        prevShip.setDisable(!enablePrevNext.get());
        shipSelectionPane.add((Node)prevShip, 0, 1);
        GridPane.setHalignment((Node)prevShip, (HPos)HPos.LEFT);
        ImageView weaponIconView = new ImageView(weaponIcon);
        weaponIconView.setId("weaponIcon");
        shipSelectionPane.add((Node)weaponIconView, 1, 1);
        GridPane.setHalignment((Node)weaponIconView, (HPos)HPos.CENTER);
        ImageView healthIconView = new ImageView(healthIcon);
        healthIconView.setId("healthIcon");
        shipSelectionPane.add((Node)healthIconView, 2, 1);
        GridPane.setHalignment((Node)healthIconView, (HPos)HPos.CENTER);
        ImageView sailorIconView = new ImageView(sailorIcon);
        sailorIconView.setId("sailorIcon");
        shipSelectionPane.add((Node)sailorIconView, 3, 1);
        GridPane.setHalignment((Node)sailorIconView, (HPos)HPos.CENTER);
        final OpenPatricianSmallWaxButton nextShip = new OpenPatricianSmallWaxButton(">");
        nextShip.setId("nextShip");
        nextShip.getStyleClass().add((Object)"actionButton");
        nextShip.setOnAction(this.createNextActionForShips(ships, currentShip));
        nextShip.setDisable(!enablePrevNext.get());
        shipSelectionPane.add((Node)nextShip, 4, 1);
        GridPane.setHalignment((Node)nextShip, (HPos)HPos.RIGHT);
        enablePrevNext.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                nextShip.setDisable(newValue == false);
                prevShip.setDisable(newValue == false);
            }
        });
        ObjectProperty<DecoratedText> text = this.createWeaponStrength((IShip)currentShip.get());
        currentShip.addListener((observable, oldValue, newValue) -> {
            DecoratedText newText = (DecoratedText)this.createWeaponStrength((IShip)newValue).get();
            shipSelectionPane.getChildren().remove(text.get());
            text.setValue((Object)newText);
            shipSelectionPane.add((Node)text.get(), 1, 2);
        });
        shipSelectionPane.add((Node)text.get(), 1, 2);
        Text damage = new Text();
        damage.setId("health");
        damage.getStyleClass().add((Object)"dialogText");
        StringBinding damageBinding = new StringBinding(){
            {
                super.bind(new Observable[]{currentShip});
            }

            protected String computeValue() {
                return String.valueOf(100 - ((IShip)currentShip.get()).getDamage());
            }
        };
        damage.textProperty().bind((ObservableValue)damageBinding);
        shipSelectionPane.add((Node)damage, 2, 2);
        GridPane.setHalignment((Node)damage, (HPos)HPos.CENTER);
        Text sailorsOnShip2 = new Text();
        sailorsOnShip2.setId("crew");
        sailorsOnShip2.getStyleClass().add((Object)"dialogText");
        final SailorOnShipBinding sailorsOnShipBinding = new SailorOnShipBinding(currentShip);
        currentShip.addListener((ChangeListener)new ChangeListener<IShip>(){

            public void changed(ObservableValue<? extends IShip> observableValue, IShip oldValue, IShip newValue) {
                sailorsOnShipBinding.delegateUnbind(new Observable[]{oldValue.numberOfSailorsProperty()});
                sailorsOnShipBinding.delegateBind(new Observable[]{newValue.numberOfSailorsProperty()});
            }
        });
        sailorsOnShip2.textProperty().bind((ObservableValue)sailorsOnShipBinding);
        shipSelectionPane.add((Node)sailorsOnShip2, 3, 2);
        GridPane.setHalignment((Node)sailorsOnShip2, (HPos)HPos.CENTER);
        return shipSelectionPane;
    }

    public GridPane createShipInfoOnThreeLines(final ObjectProperty<IShip> currentShip, boolean withShipName, int maxWidth) {
        Image weaponIcon = this.imageLoader.getImage("icons/32/bombard-icon");
        Image healthIcon = this.imageLoader.getImage("icons/32/health-icon");
        Image sailorIcon = this.imageLoader.getImage("icons/32/sailor-icon");
        Image knotIcon = this.imageLoader.getImage("icons/32/knot-icon");
        Image compassIcon = this.imageLoader.getImage("icons/32/compass-icon", 24.0, 24.0);
        GridPane shipSelectionPane = new GridPane();
        shipSelectionPane.setId("shipInfo");
        RowConstraints rowConstraint = new RowConstraints(24.0);
        shipSelectionPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraint, rowConstraint, rowConstraint});
        ColumnConstraints colConstraint = maxWidth > 600 ? new ColumnConstraints(64.0) : new ColumnConstraints(32.0);
        shipSelectionPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colConstraint, colConstraint, colConstraint, colConstraint, colConstraint});
        int row = 0;
        if (withShipName) {
            Text shipName = new Text();
            StringBinding shipNameBinding = new StringBinding(){
                {
                    super.bind(new Observable[]{currentShip});
                }

                protected String computeValue() {
                    IShip ship = (IShip)currentShip.get();
                    return DialogUtil.this.translations.getLocalDisplayName(ship.getShipType()) + " " + ship.getName();
                }
            };
            shipName.getStyleClass().add((Object)"dialogText");
            shipName.setId("shipTypeName");
            shipName.textProperty().bind((ObservableValue)shipNameBinding);
            shipSelectionPane.add((Node)shipName, 0, row, 4, 1);
            GridPane.setHalignment((Node)shipName, (HPos)HPos.LEFT);
            ++row;
        }
        ImageView knotIconView = new ImageView(knotIcon);
        knotIconView.setId("knotIcon");
        shipSelectionPane.add((Node)knotIconView, 0, row);
        GridPane.setHalignment((Node)knotIconView, (HPos)HPos.CENTER);
        ImageView weaponIconView = new ImageView(weaponIcon);
        weaponIconView.setId("weaponIcon");
        shipSelectionPane.add((Node)weaponIconView, 1, row);
        GridPane.setHalignment((Node)weaponIconView, (HPos)HPos.CENTER);
        ImageView healthIconView = new ImageView(healthIcon);
        healthIconView.setId("healthIcon");
        shipSelectionPane.add((Node)healthIconView, 2, row);
        GridPane.setHalignment((Node)healthIconView, (HPos)HPos.CENTER);
        ImageView sailorIconView = new ImageView(sailorIcon);
        sailorIconView.setId("sailorIcon");
        shipSelectionPane.add((Node)sailorIconView, 3, row);
        GridPane.setHalignment((Node)sailorIconView, (HPos)HPos.CENTER);
        ++row;
        int speedInKnots = this.shipService.convertSpeedToKnots((IShip)currentShip.get());
        Text speed = new Text(String.valueOf(speedInKnots));
        speed.setId("speed");
        speed.getStyleClass().add((Object)"dialogText");
        shipSelectionPane.add((Node)speed, 0, row);
        GridPane.setHalignment((Node)speed, (HPos)HPos.CENTER);
        ObjectProperty<DecoratedText> text = this.createWeaponStrength((IShip)currentShip.get());
        int localRow = row;
        currentShip.addListener((observable, oldValue, newValue) -> {
            DecoratedText newText = (DecoratedText)this.createWeaponStrength((IShip)newValue).get();
            shipSelectionPane.getChildren().remove(text.get());
            text.setValue((Object)newText);
            shipSelectionPane.add((Node)text.get(), 1, localRow);
        });
        shipSelectionPane.add((Node)text.get(), 1, row);
        Text damage = new Text();
        damage.setId("health");
        damage.getStyleClass().add((Object)"dialogText");
        StringBinding damageBinding = new StringBinding(){
            {
                super.bind(new Observable[]{currentShip});
            }

            protected String computeValue() {
                return String.valueOf(100 - ((IShip)currentShip.get()).getDamage());
            }
        };
        damage.textProperty().bind((ObservableValue)damageBinding);
        shipSelectionPane.add((Node)damage, 2, row);
        GridPane.setHalignment((Node)damage, (HPos)HPos.CENTER);
        Label sailorsOnShip2 = new Label();
        sailorsOnShip2.setId("crew");
        sailorsOnShip2.getStyleClass().add((Object)"dialogText");
        final SimpleSailorOnShipBinding sailorsOnShipBinding = new SimpleSailorOnShipBinding(currentShip);
        currentShip.addListener((ChangeListener)new ChangeListener<IShip>(){

            public void changed(ObservableValue<? extends IShip> observableValue, IShip oldValue, IShip newValue) {
                sailorsOnShipBinding.delegateUnbind(new Observable[]{oldValue.numberOfSailorsProperty()});
                sailorsOnShipBinding.delegateBind(new Observable[]{newValue.numberOfSailorsProperty()});
            }
        });
        Group g = new Group();
        if (((IShip)currentShip.get()).getCaptian().isPresent()) {
            ImageView imageView = new ImageView(compassIcon);
            imageView.setId("captainIcon");
            imageView.layoutXProperty().bind((ObservableValue)sailorsOnShip2.widthProperty().add(3));
            g.getChildren().addAll((Object[])new Node[]{sailorsOnShip2, imageView});
        } else {
            g.getChildren().addAll((Object[])new Node[]{sailorsOnShip2});
        }
        sailorsOnShip2.textProperty().bind((ObservableValue)sailorsOnShipBinding);
        shipSelectionPane.add((Node)g, 3, row);
        GridPane.setHalignment((Node)g, (HPos)HPos.CENTER);
        return shipSelectionPane;
    }

    private ObjectProperty<DecoratedText> createWeaponStrength(IShip currentShip) {
        int strength = this.shipService.calculateShipsWeaponsStrength((INavigableVessel)currentShip);
        String key = null;
        if (strength > 0) {
            key = strength % 2 != 0 ? (strength == 1 ? "ch.sahits.game.openpatrician.model.ship.impl.Ship.weaponStrengthOne" : "ch.sahits.game.openpatrician.model.ship.impl.Ship.weaponStrengthUneven") : "ch.sahits.game.openpatrician.model.ship.impl.Ship.weaponStrengthEven";
            String template = this.messageSource.getMessage(key, new Object[]{strength /= 2}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setId("weaponStrength");
            return new SimpleObjectProperty((Object)text);
        }
        return new SimpleObjectProperty((Object)new DecoratedText());
    }

    public Pane center(Control childNode) {
        int width = 434;
        Pane g = new Pane(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = (434.0 - childNode.getWidth()) / 2.0;
            g.setLayoutX(inset);
        });
        return g;
    }

    public Pane center(ImageView childNode) {
        int width = 434;
        Pane g = new Pane(new Node[]{childNode});
        double in = (434.0 - childNode.getImage().getWidth()) / 2.0;
        g.setLayoutX(in);
        childNode.getImage().widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = (434.0 - childNode.getImage().getWidth()) / 2.0;
            g.setLayoutX(inset);
        });
        return g;
    }

    public Group center(Pane childNode) {
        int width = 434;
        Group g = new Group(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = (434.0 - childNode.getWidth()) / 2.0;
            g.setLayoutX(inset);
        });
        if (childNode instanceof FlowPane) {
            ((FlowPane)childNode).setAlignment(Pos.CENTER);
        }
        return g;
    }

    public Group right(Pane childNode) {
        int width = 434;
        Group g = new Group(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = 434.0 - childNode.getWidth();
            g.setLayoutX(inset);
        });
        if (childNode instanceof FlowPane) {
            ((FlowPane)childNode).setAlignment(Pos.CENTER_RIGHT);
        }
        return g;
    }

    public Pane right(Control childNode) {
        int width = 434;
        Pane g = new Pane(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = 434.0 - childNode.getWidth();
            g.setLayoutX(inset);
        });
        return g;
    }

    public Node createVerticalSpacer(int heigth) {
        return new PlaceHolder(1.0, (double)heigth);
    }

    public int removeById(Pane parent, String id) {
        Preconditions.checkNotNull((Object)id, (Object)"The identifying id must not be null");
        ObservableList children = parent.getChildren();
        int index = -1;
        for (int i = 0; i < children.size(); ++i) {
            Node node = (Node)children.get(i);
            if (!id.equals(node.getId())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            children.remove(index);
        }
        return index;
    }

    public Pane createShipWeaponDisplay(IShip ship) {
        List weaponSlots = ship.getWeaponSlots();
        Pane pane = new Pane();
        pane.setId("weaponDisplay");
        ImageView deck = this.getShipDeck(ship.getShipType());
        pane.getChildren().add((Object)deck);
        for (IWeaponSlot weaponSlot : weaponSlots) {
            if (weaponSlot.getWeapon().isPresent()) {
                List offsets;
                EWeapon weapon = (EWeapon)weaponSlot.getWeapon().get();
                boolean big = this.shipService.isLargeWeapon(weapon);
                if (weaponSlot instanceof SecondaryLargeWeaponSlot && big) continue;
                int id = weaponSlot.getId();
                BasicSlot slot = this.getSlotModel(id);
                ImageView imgView = this.getShipWeapon(weaponSlot);
                Point2D offset = new Point2D(0.0, 0.0);
                if (big) {
                    offsets = this.weaponLocations.getPositioning().getBig();
                    for (BasicOffset basicOffset : offsets) {
                        if (!basicOffset.getSide().equals((Object)slot.getSide())) continue;
                        offset = new Point2D((double)basicOffset.getXOffset(), (double)basicOffset.getYOffset());
                        break;
                    }
                } else {
                    offsets = this.weaponLocations.getPositioning().getSmall();
                    for (BasicOffset basicOffset : offsets) {
                        if (!basicOffset.getSide().equals((Object)slot.getSide())) continue;
                        offset = new Point2D((double)basicOffset.getXOffset(), (double)basicOffset.getYOffset());
                        break;
                    }
                }
                imgView.setLayoutX((double)slot.getX() + offset.getX());
                imgView.setLayoutY((double)slot.getY() + offset.getY());
                pane.getChildren().add((Object)imgView);
                continue;
            }
            ImageView placeHolder = this.getWeaponPlaceHolder(weaponSlot.getSide());
            int id = weaponSlot.getId();
            BasicSlot slot = this.getSlotModel(id);
            placeHolder.setLayoutX((double)slot.getX());
            placeHolder.setLayoutY((double)slot.getY());
            pane.getChildren().add((Object)placeHolder);
        }
        return pane;
    }

    private ImageView getShipDeck(EShipType shipType) {
        String imageName = null;
        switch (shipType) {
            case SNAIKKA: {
                imageName = "images/deckSNAIKKA";
                break;
            }
            case CRAYER: {
                imageName = "images/deckCRAYER";
                break;
            }
            case COG: {
                imageName = "images/deckCOG";
                break;
            }
            case HOLK: {
                imageName = "images/deckHOLK";
            }
        }
        Image img = this.imageLoader.getImage(imageName);
        return new ImageView(img);
    }

    private ImageView getWeaponPlaceHolder(ESide side) {
        String imageName = null;
        switch (side) {
            case LEFT: {
                imageName = "images/WeaponPlaceHolderLeft";
                break;
            }
            case RIGHT: {
                imageName = "images/WeaponPlaceHolderRight";
            }
        }
        Image img = this.imageLoader.getImage(imageName);
        return new ImageView(img);
    }

    private ImageView getShipWeapon(IWeaponSlot weaponSlot) {
        ESide side = weaponSlot.getSide();
        EWeapon weapon = (EWeapon)weaponSlot.getWeapon().get();
        String imageName = null;
        switch (weapon) {
            case CANNON: {
                if (ESide.RIGHT.equals((Object)side)) {
                    imageName = "images/canonTopRight";
                    break;
                }
                imageName = "images/canonTopLeft";
                break;
            }
            case BALLISTA_BIG: {
                if (ESide.RIGHT.equals((Object)side)) {
                    imageName = "images/ballistaBigTopRight";
                    break;
                }
                imageName = "images/ballistaBigTopLeft";
                break;
            }
            case BALLISTA_SMALL: {
                if (ESide.RIGHT.equals((Object)side)) {
                    imageName = "images/ballistaSmallTopRight";
                    break;
                }
                imageName = "images/ballistaSmallTopLeft";
                break;
            }
            case BOMBARD: {
                if (ESide.RIGHT.equals((Object)side)) {
                    imageName = "images/bombardTopRight";
                    break;
                }
                imageName = "images/bombardTopLeft";
                break;
            }
            case TREBUCHET_BIG: {
                if (ESide.RIGHT.equals((Object)side)) {
                    imageName = "images/trebuchetBigTopRight";
                    break;
                }
                imageName = "images/trebuchetBigTopLeft";
                break;
            }
            case TREBUCHET_SMALL: {
                imageName = ESide.RIGHT.equals((Object)side) ? "images/trebuchetSmallTopRight" : "images/trebuchetSmallTopLeft";
            }
        }
        Image img = this.imageLoader.getImage(imageName);
        return new ImageView(img);
    }

    private BasicSlot getSlotModel(int id) {
        for (WeaponLocations.WeaponLocation weaponLocation : this.weaponLocations.getWeaponLocation()) {
            for (BasicSlot basicSlot : weaponLocation.getSlot()) {
                if (id != basicSlot.getId()) continue;
                return basicSlot;
            }
        }
        return null;
    }

    public Image getStatusIcon(EShipTravelState travelState) {
        switch (travelState) {
            case REPAIR: {
                return this.repair;
            }
            case ANCHOR: {
                return this.anchor;
            }
        }
        return this.sail;
    }

    private class SimpleSailorOnShipBinding
    extends StringBinding {
        private final ObjectProperty<IShip> currentShip;

        SimpleSailorOnShipBinding(ObjectProperty<IShip> currentShip) {
            super.bind(new Observable[]{currentShip, ((IShip)currentShip.get()).numberOfSailorsProperty()});
            this.currentShip = currentShip;
        }

        protected String computeValue() {
            IShip ship = (IShip)this.currentShip.get();
            return String.valueOf(ship.getNumberOfSailors());
        }

        public void delegateUnbind(Observable ... values) {
            this.unbind(values);
        }

        public void delegateBind(Observable ... values) {
            this.bind(values);
        }
    }

    private class SailorOnShipBinding
    extends StringBinding {
        private final ObjectProperty<IShip> currentShip;

        SailorOnShipBinding(ObjectProperty<IShip> currentShip) {
            super.bind(new Observable[]{currentShip, ((IShip)currentShip.get()).numberOfSailorsProperty()});
            this.currentShip = currentShip;
        }

        protected String computeValue() {
            IShip ship = (IShip)this.currentShip.get();
            return String.valueOf(ship.getNumberOfSailors()) + " (" + ship.getMinNumberOfSailors() + " - " + ship.getMaxNumberOfSailors() + ")";
        }

        public void delegateUnbind(Observable ... values) {
            this.unbind(values);
        }

        public void delegateBind(Observable ... values) {
            this.bind(values);
        }
    }
}

