/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.ship;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipInfoDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX proxy;
    @DependentValue(value="sailor.cost.per.day")
    private double dailySailorCost = 0.5;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private IDataImageLoader imageLoader;
    @Autowired
    private CaptainsState captainsState;
    @Autowired
    private Date date;
    @Autowired
    private DependentPropertyInitializer propertyInitializer;

    public ShipInfoDialog(ICityPlayerProxyJFX proxy) {
        this.proxy = proxy;
    }

    @PostConstruct
    private void initializeDialog() {
        final IShip activeShip = (IShip)this.proxy.getActiveShip();
        SimpleObjectProperty shipProperty = new SimpleObjectProperty((Object)activeShip);
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.title", new Object[]{activeShip.getName()}, this.locale.getCurrentLocal()));
        GridPane sailorsPane = new GridPane();
        sailorsPane.setId("shipInfo");
        sailorsPane.setLayoutY(100.0);
        sailorsPane.setLayoutX(30.0);
        ColumnConstraints col1Constraints = new ColumnConstraints();
        col1Constraints.setPercentWidth(50.0);
        ColumnConstraints col2Constraints = new ColumnConstraints();
        col2Constraints.setPercentWidth(50.0);
        sailorsPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1Constraints, col2Constraints});
        HBox sailorsBox = new HBox(10.0);
        sailorsBox.setId("sailorsBox");
        sailorsBox.setAlignment(Pos.CENTER);
        Image img = this.imageLoader.getImage("icons/128/sailor-icon");
        ImageView headView = new ImageView(img);
        headView.setScaleX(0.5);
        headView.setScaleY(0.5);
        Label sailorNumbers = new Label();
        StringBinding sailorNumberBinding = new StringBinding(){
            {
                super.bind(new Observable[]{activeShip.numberOfSailorsProperty()});
            }

            protected String computeValue() {
                return activeShip.getNumberOfSailors() + " (" + activeShip.getMinNumberOfSailors() + " - " + activeShip.getMaxNumberOfSailors() + ")";
            }
        };
        sailorNumbers.setText(sailorNumberBinding.get());
        sailorNumbers.getStyleClass().addAll((Object[])new String[]{"dialogText"});
        sailorNumbers.textProperty().bind((ObservableValue)sailorNumberBinding);
        sailorsBox.getChildren().addAll((Object[])new Node[]{headView, sailorNumbers});
        sailorsPane.add((Node)sailorsBox, 0, 0);
        HBox salaryBox = new HBox(10.0);
        salaryBox.setId("salaryBox");
        salaryBox.setAlignment(Pos.CENTER);
        img = this.imageLoader.getImage("icons/128/tradeskill_icon");
        ImageView coinsView = new ImageView(img);
        coinsView.setScaleX(0.5);
        coinsView.setScaleY(0.5);
        Label sailorSalaryLbl = new Label();
        sailorSalaryLbl.setId("sailorSalaryLbl");
        StringBinding sailorSalaryBinding = new StringBinding(){
            {
                super.bind(new Observable[]{activeShip.numberOfSailorsProperty()});
            }

            protected String computeValue() {
                INavigableVessel ship = ShipInfoDialog.this.proxy.getActiveShip();
                double sailorSalary = (double)ship.getNumberOfSailors() * ShipInfoDialog.this.dailySailorCost;
                if (ship.getCaptian().isPresent()) {
                    ICaptain captain = (ICaptain)ship.getCaptian().get();
                    sailorSalary += (double)captain.getSalary();
                }
                return ShipInfoDialog.this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.sailorSalaery", new Object[]{sailorSalary *= 7.0}, ShipInfoDialog.this.locale.getCurrentLocal());
            }
        };
        sailorSalaryLbl.setText(sailorSalaryBinding.get());
        sailorSalaryLbl.getStyleClass().addAll((Object[])new String[]{"dialogText"});
        sailorSalaryLbl.textProperty().bind((ObservableValue)sailorSalaryBinding);
        salaryBox.getChildren().addAll((Object[])new Node[]{coinsView, sailorSalaryLbl});
        sailorsPane.add((Node)salaryBox, 1, 0);
        HBox dismissSailorBox = new HBox(10.0);
        dismissSailorBox.setId("dismissSailorBox");
        dismissSailorBox.setAlignment(Pos.CENTER);
        img = this.imageLoader.getImage("icons/plusIcon");
        ImageView plusIcon = new ImageView(img);
        plusIcon.setId("plusIcon");
        SimpleIntegerProperty dismissNbSailors = new SimpleIntegerProperty(0);
        plusIcon.setOnMouseReleased(arg_0 -> ShipInfoDialog.lambda$initializeDialog$0((ObjectProperty)shipProperty, (IntegerProperty)dismissNbSailors, arg_0));
        Label dismissNbSailorsLbl = new Label();
        dismissNbSailorsLbl.setId("dismissNbSailorsLbl");
        dismissNbSailorsLbl.getStyleClass().add((Object)"dialogText");
        dismissNbSailorsLbl.setText("0");
        dismissNbSailorsLbl.textProperty().bind((ObservableValue)dismissNbSailors.asString());
        img = this.imageLoader.getImage("icons/minusIcon");
        ImageView minusIcon = new ImageView(img);
        minusIcon.setId("minusIcon");
        minusIcon.setOnMouseReleased(arg_0 -> ShipInfoDialog.lambda$initializeDialog$1((IntegerProperty)dismissNbSailors, arg_0));
        dismissSailorBox.getChildren().addAll((Object[])new Node[]{plusIcon, dismissNbSailorsLbl, minusIcon});
        sailorsPane.add((Node)dismissSailorBox, 0, 1);
        OpenPatricianLargeWaxButton dismissBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.dismissSailors", new Object[0], this.locale.getCurrentLocal()));
        dismissBtn.setId("dismissBtn");
        dismissBtn.getStyleClass().add((Object)"actionButton");
        dismissBtn.setOnAction(arg_0 -> ShipInfoDialog.lambda$initializeDialog$2((ObjectProperty)shipProperty, (IntegerProperty)dismissNbSailors, arg_0));
        sailorsPane.add((Node)dismissBtn, 1, 1);
        HBox handWeaponBox = new HBox(10.0);
        handWeaponBox.setId("handWeaponBox");
        handWeaponBox.setAlignment(Pos.CENTER);
        img = this.imageLoader.getImage("icons/128/cutlass_icon");
        ImageView cutlassView = new ImageView(img);
        cutlassView.setScaleX(0.5);
        cutlassView.setScaleY(0.5);
        Label weaponsLbl = new Label(String.valueOf(this.proxy.getActiveShip().getWeaponAmount((IWeapon)EWeapon.HAND_WEAPON)));
        weaponsLbl.getStyleClass().addAll((Object[])new String[]{"dialogText"});
        handWeaponBox.getChildren().addAll((Object[])new Node[]{cutlassView, weaponsLbl});
        sailorsPane.add((Node)handWeaponBox, 0, 2, 2, 1);
        GridPane.setHalignment((Node)handWeaponBox, (HPos)HPos.CENTER);
        if (this.proxy.getActiveShip().getCaptian().isPresent()) {
            ICaptain captain = (ICaptain)this.proxy.getActiveShip().getCaptian().get();
            String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.captainName", new Object[]{captain.getName(), captain.getAge()}, this.locale.getCurrentLocal());
            Label captainName = new Label(s);
            captainName.getStyleClass().addAll((Object[])new String[]{"dialogText"});
            captainName.setId("captainName");
            sailorsPane.add((Node)captainName, 0, 3, 2, 1);
            GridPane.setHalignment((Node)captainName, (HPos)HPos.CENTER);
            HBox captainCapabilityBox = new HBox(10.0);
            captainCapabilityBox.setId("captainCapabilityBox");
            captainCapabilityBox.setAlignment(Pos.CENTER);
            img = this.imageLoader.getImage("icons/64/trade-icon");
            ImageView tradeView = new ImageView(img);
            tradeView.setScaleX(0.5);
            tradeView.setScaleY(0.5);
            Label tradeLbl = new Label(String.valueOf(captain.getTradingSkillLevel()));
            tradeLbl.getStyleClass().addAll((Object[])new String[]{"dialogText"});
            img = this.imageLoader.getImage("icons/64/compass-icon");
            ImageView navigationView = new ImageView(img);
            navigationView.setScaleX(0.5);
            navigationView.setScaleY(0.5);
            Label navigationLbl = new Label(String.valueOf(captain.getNavigationSkillLevel()));
            navigationLbl.getStyleClass().addAll((Object[])new String[]{"dialogText"});
            img = this.imageLoader.getImage("icons/64/fightskill_icon");
            ImageView fightView = new ImageView(img);
            fightView.setScaleX(0.5);
            fightView.setScaleY(0.5);
            Label fightLbl = new Label(String.valueOf(captain.getFightSkillLevel()));
            fightLbl.getStyleClass().addAll((Object[])new String[]{"dialogText"});
            captainCapabilityBox.getChildren().addAll((Object[])new Node[]{tradeView, tradeLbl, navigationView, navigationLbl, fightView, fightLbl});
            sailorsPane.add((Node)captainCapabilityBox, 0, 4, 2, 1);
            GridPane.setHalignment((Node)captainCapabilityBox, (HPos)HPos.CENTER);
            OpenPatricianLargeWaxButton dismissCaptain = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.dismissCaptain", new Object[0], this.locale.getCurrentLocal()));
            dismissCaptain.setId("dismissCaptain");
            dismissCaptain.getStyleClass().add((Object)"actionButton");
            dismissCaptain.setOnAction(arg_0 -> this.lambda$initializeDialog$3((ObjectProperty)shipProperty, captain, captainCapabilityBox, captainName, dismissCaptain, sailorSalaryBinding, arg_0));
            sailorsPane.add((Node)dismissCaptain, 0, 5);
            GridPane.setHalignment((Node)dismissCaptain, (HPos)HPos.CENTER);
        }
        OpenPatricianLargeWaxButton togglePirate = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog.switchPirate", new Object[0], this.locale.getCurrentLocal()));
        togglePirate.setId("togglePirate");
        togglePirate.getStyleClass().add((Object)"actionButton");
        togglePirate.setOnAction(arg_0 -> this.lambda$initializeDialog$4((ObjectProperty)shipProperty, arg_0));
        sailorsPane.add((Node)togglePirate, 1, 5);
        GridPane.setHalignment((Node)togglePirate, (HPos)HPos.CENTER);
        this.getContent().addAll((Object[])new Node[]{sailorsPane});
    }

    private /* synthetic */ void lambda$initializeDialog$4(ObjectProperty shipProperty, MouseEvent event) {
        IShip ship = (IShip)shipProperty.get();
        ship.togglePirateFlag();
        this.executeOnCloseButtonClicked();
    }

    private /* synthetic */ void lambda$initializeDialog$3(ObjectProperty shipProperty, ICaptain captain, HBox captainCapabilityBox, Label captainName, OpenPatricianLargeWaxButton dismissCaptain, StringBinding sailorSalaryBinding, MouseEvent event) {
        IShip ship = (IShip)shipProperty.get();
        ship.setCaptain(null);
        this.captainsState.addCaptain(this.proxy.getCity(), this.date.getCurrentDate(), captain);
        captainCapabilityBox.setVisible(false);
        captainName.setVisible(false);
        dismissCaptain.setVisible(false);
        sailorSalaryBinding.invalidate();
    }

    private static /* synthetic */ void lambda$initializeDialog$2(ObjectProperty shipProperty, IntegerProperty dismissNbSailors, MouseEvent event) {
        IShip ship = (IShip)shipProperty.get();
        ship.setNumberOfSailors(ship.getNumberOfSailors() - dismissNbSailors.get());
        dismissNbSailors.setValue((Number)0);
    }

    private static /* synthetic */ void lambda$initializeDialog$1(IntegerProperty dismissNbSailors, MouseEvent e) {
        int value = Math.max(0, dismissNbSailors.get() - 1);
        dismissNbSailors.setValue((Number)value);
    }

    private static /* synthetic */ void lambda$initializeDialog$0(ObjectProperty shipProperty, IntegerProperty dismissNbSailors, MouseEvent e) {
        IShip ship = (IShip)shipProperty.get();
        int value = Math.min(ship.getNumberOfSailors(), dismissNbSailors.get() + 1);
        dismissNbSailors.setValue((Number)value);
    }
}

