/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.ship;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.sea.TravellingVessel;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.EShipTravelState;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.Optional;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.MODEL, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipModelForShipList {
    private final IShip ship;
    @Autowired
    private ShipService shipService;
    @Autowired
    private TravellingVessels travellingVessels;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;

    public ShipModelForShipList(IShip ship) {
        this.ship = ship;
    }

    public Optional<ShipModelForShipList> getParent() {
        if (this.ship.parentShipProperty().getValue() != null) {
            return Optional.of(new ShipModelForShipList((IShip)this.ship.parentShipProperty().getValue()));
        }
        return Optional.empty();
    }

    public String getShipName() {
        return this.ship.getName();
    }

    public EShipType getShipType() {
        return this.ship.getShipType();
    }

    public ObjectProperty<EShipTravelState> travelingState() {
        return this.ship.travelState();
    }

    public StringBinding destination() {
        return new StringBinding(){

            protected String computeValue() {
                switch ((EShipTravelState)ShipModelForShipList.this.ship.travelState().get()) {
                    case ANCHOR: 
                    case REPAIR: {
                        Optional city = ShipModelForShipList.this.shipService.findCity((INavigableVessel)ShipModelForShipList.this.ship);
                        if (city.isPresent()) {
                            return ((ICity)city.get()).getName();
                        }
                    }
                    case TRAVEL_TO_CITY: {
                        TravellingVessel travelling = ShipModelForShipList.this.getParent().isPresent() ? ShipModelForShipList.this.travellingVessels.getTravellingVessel((INavigableVessel)ShipModelForShipList.this.ship.parentShipProperty().get()) : ShipModelForShipList.this.travellingVessels.getTravellingVessel((INavigableVessel)ShipModelForShipList.this.ship);
                        Point2D destination = (Point2D)travelling.getCalculatablePath().get(travelling.getCalculatablePath().size() - 1);
                        Optional city = ShipModelForShipList.this.travellingVessels.findCity(destination);
                        if (city.isPresent()) {
                            return ((ICity)city.get()).getName();
                        }
                    }
                    case EXPEDITION: {
                        return ShipModelForShipList.this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ship.ShipListDialog.expedition", new Object[0], ShipModelForShipList.this.locale.getCurrentLocal());
                    }
                }
                return "";
            }
        };
    }

    public int getHealth() {
        return 100 - this.ship.getDamage();
    }

    public IntegerBinding loadedWares() {
        return this.ship.getLoadBinding();
    }

    public int getValue() {
        return this.ship.getCargoValue();
    }

    public boolean isPlayersShip(IHumanPlayer player) {
        return this.ship.getOwner().equals(player);
    }

    public boolean isAutotrading() {
        return this.ship.getAutotrading().isPresent();
    }

    public IShip getShip() {
        return this.ship;
    }
}

