/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.impl.ThieveState;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernBurglarDialog
extends TavernBaseSideRoomPersonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernBurglarDialog.class);
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;";
    @ListType(value=IPlayer.class)
    private final List<IPlayer> residentOponents = Lists.newArrayList();
    @ObjectPropertyType(value=IPlayer.class)
    private ObjectProperty<IPlayer> selectedOponent = new SimpleObjectProperty((Object)this, "selectedOpponent", null);
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private DecoratedTextFactory textFactory;
    private BooleanBinding disabeAcceptBinding;
    @Autowired
    private ModelTranslations modelTranslator;

    public TavernBurglarDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getThieve());
        for (IPlayer player : city.getCity().getResidentPlayers()) {
            if (player.equals(city.getPlayer())) continue;
            this.residentOponents.add(player);
        }
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBurglarDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        VBox box = new VBox();
        box.setLayoutX(30.0);
        box.setLayoutY(100.0);
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBurglarDialog.dialog1", new Object[0], this.locale.getCurrentLocal());
        DecoratedText line1 = this.textFactory.createDecoratedText(template, new HashMap());
        DecoratedText emptyLine = this.textFactory.createDecoratedText(" \n", new HashMap());
        box.getChildren().addAll((Object[])new Node[]{line1, emptyLine});
        ArrayList opponents = Lists.newArrayList();
        for (IPlayer opponent : this.residentOponents) {
            String sb = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBurglarDialog.list", new Object[]{this.modelTranslator.getLocalDisplayName(opponent.getCareerLevel()), this.modelTranslator.getLocalDisplayName(opponent.getRank()), opponent.getName(), opponent.getLastName(), opponent.getHometown().getName()}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(sb, new HashMap());
            text.setUserData((Object)opponent);
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
            box.getChildren().add((Object)text);
            opponents.add(text);
        }
        for (IPlayer opponent : opponents) {
            opponent.setOnMouseReleased(arg_0 -> this.lambda$initializeDialog$0((DecoratedText)opponent, opponents, arg_0));
        }
        this.getContent().add((Object)box);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IHumanPlayer player = this.city.getPlayer();
                ThieveState burglar = (ThieveState)this.currentPerson.get();
                player.getCompany().updateCash((long)(-burglar.getPrice()));
                int probability = this.rnd.nextInt(3);
                if (probability < 1) {
                    this.timedTaskListener.add((TimedTask)this.taskFactory.getDelayedCaughtAction((IPlayer)player, this.city.getCity()));
                } else {
                    this.timedTaskListener.add((TimedTask)this.taskFactory.getBreakInAction((IPlayer)this.selectedOponent.get()));
                }
                player.updateCrimialDrive(1);
                burglar.leave();
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to accept burglar offer", (Throwable)e);
            }
        };
    }

    private void resetStyles(List<DecoratedText> texts) {
        for (DecoratedText text : texts) {
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        if (this.disabeAcceptBinding == null) {
            this.disabeAcceptBinding = new BooleanBinding(){

                protected boolean computeValue() {
                    return !TavernBurglarDialog.this.residentOponents.isEmpty() && TavernBurglarDialog.this.selectedOponent.get() == null;
                }
            };
        }
        return this.disabeAcceptBinding;
    }

    private /* synthetic */ void lambda$initializeDialog$0(DecoratedText opponent, List opponents, MouseEvent mouseEvent) {
        this.selectedOponent.set((Object)((IPlayer)opponent.getUserData()));
        this.disableAcceptButton().invalidate();
        this.resetStyles(opponents);
        opponent.setStyle(SELECTED_STYLE);
    }
}

