/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernConcurrentDialog
extends TavernBaseSideRoomPersonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernConcurrentDialog.class);
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernConcurrentDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getConcurrent());
        this.setTitle(((IConcurrent)this.currentPerson.get()).getName());
    }

    @PostConstruct
    private void initializeDialog() {
        this.initializeButtons();
        IConcurrent concurrent = (IConcurrent)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernConcurrentDialog.dialog", new Object[]{this.city.getPlayer().getLastName(), concurrent.getName(), concurrent.getPremium()}, this.locale.getCurrentLocal());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, new HashMap());
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IConcurrent concurrent = (IConcurrent)this.currentPerson.get();
                int minutes = this.rnd.nextInt(600);
                LocalDateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
                DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.openpatrician.display.dialog.TavernConcurrentDialog.acceptTitle").messageKey("ch.sahits.game.openpatrician.display.dialog.TavernConcurrentDialog.acceptMessage").messageArgs(new Object[]{this.city.getCity().getName(), concurrent.getConcurrentName()}).build();
                this.taskFactory.getPostponedDisplayDialogMessage(postMessage, EMessageCategory.TRADE, template);
                TimedTask reconsialistation = this.taskFactory.getConcurrentReconciliation();
                this.eventHandlerFactory.getSinkConcurrentsShipOrder(concurrent.getConcurrentPlayer(), (IPlayer)this.city.getPlayer(), 20, concurrent.getPremium(), reconsialistation);
                this.taskFactory.getOpponentsOrder(concurrent.getConcurrentPlayer(), concurrent.getClientPlayer(), (IPlayer)this.city.getPlayer(), concurrent.getPremium() * 2);
                concurrent.leave();
                this.city.getPlayer().updateCrimialDrive(1);
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to accept concurrent attack offer", (Throwable)e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

