/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.LinearDeadlinePremiumCalculator;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernFugativeDialog
extends TavernBaseSideRoomPersonDialog {
    private static final Logger log = LoggerFactory.getLogger(TavernFugativeDialog.class);
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientServerFactory clientServerFactory;

    public TavernFugativeDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getFugative());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IFugitive fugitive = (IFugitive)this.currentPerson.get();
        DecoratedText text = new DecoratedText();
        text.setLayoutX(30.0);
        text.setLayoutY(100.0);
        text.setWrappingWidth(458);
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("destination", fugitive.getDestination().getName());
        parameters.put("amount", fugitive.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){
            {
                if (TavernFugativeDialog.this.city.getActiveShip() instanceof IShip) {
                    ((IShip)TavernFugativeDialog.this.city.getActiveShip()).passengerPresentProperty();
                }
            }

            protected boolean computeValue() {
                return !(TavernFugativeDialog.this.city.getActiveShip() instanceof IShip) || TavernFugativeDialog.this.city.getPlayersShips().isEmpty() || ((IShip)TavernFugativeDialog.this.city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IShip ship = null;
                if (this.city.getActiveShip() instanceof IShip) {
                    ship = (IShip)this.city.getActiveShip();
                }
                if (ship != null) {
                    IFugitive fugitive = (IFugitive)this.currentPerson.get();
                    ship.addPassenger((IPerson)fugitive);
                    LocalDateTime now = this.date.getCurrentDate();
                    LocalDateTime deadline = fugitive.getArrivalAtDestinationDate();
                    LinearDeadlinePremiumCalculator premiumCalculator = this.clientServerFactory.premiumCalculator(now, deadline, fugitive.getPremium());
                    DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{fugitive.getDestination().getName(), ship.getName(), this.clientServerFactory.dateSupplier(), premiumCalculator});
                    this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, fugitive.getDestination(), (IPlayer)this.city.getPlayer(), deadline, EDialogTemplateType.FUGITIVE_LEAVES_SHIP, parameterSupplier, premiumCalculator);
                    this.clientEventBus.post((Object)new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.acceptMessage", new Object[]{ship.getName()}));
                    fugitive.leave();
                    this.city.getPlayer().updateCrimialDrive(-1);
                    this.executeOnCloseButtonClicked();
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to accept fugitive offer", (Throwable)e);
            }
        };
    }
}

